package com.zehong.system.service;

import java.io.IOException;
import java.util.List;
import com.zehong.system.domain.TBankSubject;
import org.springframework.web.multipart.MultipartFile;

/**
 * 题库题目Service接口
 *
 * @author zehong
 * @date 2022-12-15
 */
public interface ITBankSubjectService
{
    /**
     * 查询题库题目
     *
     * @param subjectId 题库题目ID
     * @return 题库题目
     */
    public TBankSubject selectTBankSubjectById(Long subjectId);

    /**
     * 查询题库题目列表
     *
     * @param tBankSubject 题库题目
     * @return 题库题目集合
     */
    public List<TBankSubject> selectTBankSubjectList(TBankSubject tBankSubject);

    /**
     * 新增题库题目
     *
     * @param tBankSubject 题库题目
     * @return 结果
     */
    public int insertTBankSubject(TBankSubject tBankSubject);

    /**
     * 修改题库题目
     *
     * @param tBankSubject 题库题目
     * @return 结果
     */
    public int updateTBankSubject(TBankSubject tBankSubject);

    /**
     * 批量删除题库题目
     *
     * @param subjectIds 需要删除的题库题目ID
     * @return 结果
     */
    public int deleteTBankSubjectByIds(Long[] subjectIds);

    /**
     * 删除题库题目信息
     *
     * @param subjectId 题库题目ID
     * @return 结果
     */
    public int deleteTBankSubjectById(Long subjectId);

    /**
     * 题目信息导入
     * @param userList
     * @param updateSupport
     * @return
     */
    String importDevice(MultipartFile userList, boolean updateSupport) throws IOException;

    /**
     * excel导入
     * @param list
     */
    void insertBank(List<TBankSubject> list);
}
