package com.zehong.system.mapper;

import java.util.List;

import com.zehong.system.domain.StatisticsTrainCourse;
import com.zehong.system.domain.TTrainCourse;
import com.zehong.system.domain.vo.UserCourseVo;
import org.apache.ibatis.annotations.Param;

/**
 * 培训课程Mapper接口
 * 
 * @author zehong
 * @date 2022-09-19
 */
public interface TTrainCourseMapper 
{
    /**
     * 查询培训课程
     * 
     * @param courseId 培训课程ID
     * @return 培训课程
     */
    public TTrainCourse selectTTrainCourseById(Long courseId);

    /**
     * 查询培训课程列表
     * 
     * @param tTrainCourse 培训课程
     * @return 培训课程集合
     */
    public List<TTrainCourse> selectTTrainCourseList(TTrainCourse tTrainCourse);

    /**
     * 新增培训课程
     * 
     * @param tTrainCourse 培训课程
     * @return 结果
     */
    public int insertTTrainCourse(TTrainCourse tTrainCourse);

    /**
     * 修改培训课程
     * 
     * @param tTrainCourse 培训课程
     * @return 结果
     */
    public int updateTTrainCourse(TTrainCourse tTrainCourse);

    /**
     * 删除培训课程
     * 
     * @param courseId 培训课程ID
     * @return 结果
     */
    public int deleteTTrainCourseById(Long courseId);

    /**
     * 批量删除培训课程
     * 
     * @param courseIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTrainCourseByIds(Long[] courseIds);

    /**
     * 批量新增用户课程
     * @param courseId
     * @param userIds
     * @return
     */
    public int insertUserCourse(@Param("courseId") Long courseId,@Param("userIds") List<String> userIds,@Param("personnelType")Integer personnelType);

    /**
     * 用户课程表
     * @param userId
     * @return
     */
    public List<UserCourseVo> userCourseList(@Param("userId")Long userId,@Param("type") Integer type,@Param("personnelType")Integer personnelType);

    /**
     * 考试统计接口
     * @param statisticsTrainCourse 统计实体
     * @return List<StatisticsTrainCourse>
     */
    List<StatisticsTrainCourse> statisticsTrainCourse(StatisticsTrainCourse statisticsTrainCourse);
}
