package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TStaningBook;

/**
 * 隐患台账Mapper接口
 * 
 * @author zehong
 * @date 2022-07-09
 */
public interface TStaningBookMapper 
{
    /**
     * 查询隐患台账
     * 
     * @param bookId 隐患台账ID
     * @return 隐患台账
     */
    public TStaningBook selectTStaningBookById(Long bookId);

    /**
     * 查询隐患台账列表
     * 
     * @param tStaningBook 隐患台账
     * @return 隐患台账集合
     */
    public List<TStaningBook> selectTStaningBookList(TStaningBook tStaningBook);

    /**
     * 新增隐患台账
     * 
     * @param tStaningBook 隐患台账
     * @return 结果
     */
    public int insertTStaningBook(TStaningBook tStaningBook);

    /**
     * 修改隐患台账
     * 
     * @param tStaningBook 隐患台账
     * @return 结果
     */
    public int updateTStaningBook(TStaningBook tStaningBook);

    /**
     * 删除隐患台账
     * 
     * @param bookId 隐患台账ID
     * @return 结果
     */
    public int deleteTStaningBookById(Long bookId);

    /**
     * 批量删除隐患台账
     * 
     * @param bookIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTStaningBookByIds(Long[] bookIds);

    public Map statics(String type);
}
