package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TRepairOrder;
import com.zehong.system.domain.vo.TRepairOrderVo;

/**
 * 设备维修工单Mapper接口
 * 
 * @author zehong
 * @date 2022-07-04
 */
public interface TRepairOrderMapper 
{
    /**
     * 获取工单编号
     *
     * @return 工单编号
     */
    public String getRepairOrderCode();

    /**
     * 查询设备维修工单
     * 
     * @param id 设备维修工单ID
     * @return 设备维修工单
     */
    public TRepairOrderVo selectTRepairOrderById(Long id);

    /**
     * 查询设备维修工单列表
     * 
     * @param tRepairOrder 设备维修工单
     * @return 设备维修工单集合
     */
    public List<TRepairOrderVo> selectTRepairOrderList(TRepairOrder tRepairOrder);

    /**
     * 新增设备维修工单
     * 
     * @param tRepairOrder 设备维修工单
     * @return 结果
     */
    public int insertTRepairOrder(TRepairOrder tRepairOrder);

    /**
     * 修改设备维修工单
     * 
     * @param tRepairOrder 设备维修工单
     * @return 结果
     */
    public int updateTRepairOrder(TRepairOrder tRepairOrder);

    /**
     * 删除设备维修工单
     * 
     * @param id 设备维修工单ID
     * @return 结果
     */
    public int deleteTRepairOrderById(Long id);

    /**
     * 批量删除设备维修工单
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTRepairOrderByIds(Long[] ids);
}
