package com.zehong.system.mapper;

import com.zehong.system.domain.TPlanInfo;

import java.util.List;

/**
 * 应急处置方案Mapper接口
 * 
 * @author zehong
 * @date 2022-06-01
 */
public interface TPlanInfoMapper 
{
    /**
     * 查询应急处置方案
     * 
     * @param planId 应急处置方案ID
     * @return 应急处置方案
     */
    public TPlanInfo selectTPlanInfoById(Long planId);

    /**
     * 查询应急处置方案列表
     * 
     * @param tPlanInfo 应急处置方案
     * @return 应急处置方案集合
     */
    public List<TPlanInfo> selectTPlanInfoList(TPlanInfo tPlanInfo);

    /**
     * 新增应急处置方案
     * 
     * @param tPlanInfo 应急处置方案
     * @return 结果
     */
    public int insertTPlanInfo(TPlanInfo tPlanInfo);

    /**
     * 修改应急处置方案
     * 
     * @param tPlanInfo 应急处置方案
     * @return 结果
     */
    public int updateTPlanInfo(TPlanInfo tPlanInfo);

    /**
     * 删除应急处置方案
     * 
     * @param planId 应急处置方案ID
     * @return 结果
     */
    public int deleteTPlanInfoById(Long planId);

    /**
     * 批量删除应急处置方案
     * 
     * @param planIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPlanInfoByIds(Long[] planIds);
}
