package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TNfcRecord;

/**
 * nfc巡检记录idMapper接口
 * 
 * @author zehong
 * @date 2022-10-18
 */
public interface TNfcRecordMapper 
{
    /**
     * 查询nfc巡检记录id
     * 
     * @param recordId nfc巡检记录idID
     * @return nfc巡检记录id
     */
    public TNfcRecord selectTNfcRecordById(Long recordId);

    /**
     * 查询nfc巡检记录id列表
     * 
     * @param tNfcRecord nfc巡检记录id
     * @return nfc巡检记录id集合
     */
    public List<TNfcRecord> selectTNfcRecordList(TNfcRecord tNfcRecord);

    /**
     * 新增nfc巡检记录id
     * 
     * @param tNfcRecord nfc巡检记录id
     * @return 结果
     */
    public int insertTNfcRecord(TNfcRecord tNfcRecord);

    /**
     * 修改nfc巡检记录id
     * 
     * @param tNfcRecord nfc巡检记录id
     * @return 结果
     */
    public int updateTNfcRecord(TNfcRecord tNfcRecord);

    /**
     * 删除nfc巡检记录id
     * 
     * @param recordId nfc巡检记录idID
     * @return 结果
     */
    public int deleteTNfcRecordById(Long recordId);

    /**
     * 批量删除nfc巡检记录id
     * 
     * @param recordIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTNfcRecordByIds(Long[] recordIds);
}
