package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TMapDeviceMonitor;

/**
 * 上图设备监测Mapper接口
 * 
 * @author zehong
 * @date 2022-10-08
 */
public interface TMapDeviceMonitorMapper 
{
    /**
     * 查询上图设备监测
     * 
     * @param monitorId 上图设备监测ID
     * @return 上图设备监测
     */
    public TMapDeviceMonitor selectTMapDeviceMonitorById(Long monitorId);

    /**
     * 查询上图设备监测列表
     * 
     * @param tMapDeviceMonitor 上图设备监测
     * @return 上图设备监测集合
     */
    public List<TMapDeviceMonitor> selectTMapDeviceMonitorList(TMapDeviceMonitor tMapDeviceMonitor);

    /**
     * 新增上图设备监测
     * 
     * @param tMapDeviceMonitor 上图设备监测
     * @return 结果
     */
    public int insertTMapDeviceMonitor(TMapDeviceMonitor tMapDeviceMonitor);

    /**
     * 修改上图设备监测
     * 
     * @param tMapDeviceMonitor 上图设备监测
     * @return 结果
     */
    public int updateTMapDeviceMonitor(TMapDeviceMonitor tMapDeviceMonitor);

    /**
     * 删除上图设备监测
     * 
     * @param monitorId 上图设备监测ID
     * @return 结果
     */
    public int deleteTMapDeviceMonitorById(Long monitorId);

    /**
     * 批量删除上图设备监测
     * 
     * @param monitorIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTMapDeviceMonitorByIds(Long[] monitorIds);
}
