package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TMapDeviceInfo;

/**
 * 上图设备信息Mapper接口
 * 
 * @author zehong
 * @date 2022-10-08
 */
public interface TMapDeviceInfoMapper 
{
    /**
     * 查询上图设备信息
     * 
     * @param mapDeviceId 上图设备信息ID
     * @return 上图设备信息
     */
    public TMapDeviceInfo selectTMapDeviceInfoById(Long mapDeviceId);

    /**
     * 查询上图设备信息列表
     * 
     * @param tMapDeviceInfo 上图设备信息
     * @return 上图设备信息集合
     */
    public List<TMapDeviceInfo> selectTMapDeviceInfoList(TMapDeviceInfo tMapDeviceInfo);

    /**
     * 新增上图设备信息
     * 
     * @param tMapDeviceInfo 上图设备信息
     * @return 结果
     */
    public int insertTMapDeviceInfo(TMapDeviceInfo tMapDeviceInfo);

    /**
     * 修改上图设备信息
     * 
     * @param tMapDeviceInfo 上图设备信息
     * @return 结果
     */
    public int updateTMapDeviceInfo(TMapDeviceInfo tMapDeviceInfo);

    /**
     * 删除上图设备信息
     * 
     * @param mapDeviceId 上图设备信息ID
     * @return 结果
     */
    public int deleteTMapDeviceInfoById(Long mapDeviceId);

    /**
     * 批量删除上图设备信息
     * 
     * @param mapDeviceIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTMapDeviceInfoByIds(Long[] mapDeviceIds);

    /**
     * 获取所有上图设备信息
     * @param tMapDeviceInfo
     * @return
     */
    List<TMapDeviceInfo> deviceInfoLists(TMapDeviceInfo tMapDeviceInfo);
}
