package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TInspectWorkInfo;
import org.apache.ibatis.annotations.Param;

/**
 * 巡检任务信息Mapper接口
 * 
 * @author zehong
 * @date 2022-06-20
 */
public interface TInspectWorkInfoMapper 
{
    /**
     * 查询巡检任务信息
     * 
     * @param workId 巡检任务信息ID
     * @return 巡检任务信息
     */
    public TInspectWorkInfo selectTInspectWorkInfoById(Long workId);

    /**
     * 查询巡检任务信息列表
     * 
     * @param tInspectWorkInfo 巡检任务信息
     * @return 巡检任务信息集合
     */
    public List<TInspectWorkInfo> selectTInspectWorkInfoList(TInspectWorkInfo tInspectWorkInfo);
    //app专用
    public List<TInspectWorkInfo> taskList(TInspectWorkInfo tInspectWorkInfo);
    //定时筛选不同类型任务
    public List<TInspectWorkInfo> selectTInspectWorkInfoList2(@Param("workType") Integer workType);
    //查询子类任务
    public List<TInspectWorkInfo> selectTInspectWorkInfoListLimit(@Param("parentId")long parentId );

    /**
     * 新增巡检任务信息
     * 
     * @param tInspectWorkInfo 巡检任务信息
     * @return 结果
     */
    public int insertTInspectWorkInfo(TInspectWorkInfo tInspectWorkInfo);

    /**
     * 修改巡检任务信息
     * 
     * @param tInspectWorkInfo 巡检任务信息
     * @return 结果
     */
    public int updateTInspectWorkInfo(TInspectWorkInfo tInspectWorkInfo);

    /**
     * 删除巡检任务信息
     * 
     * @param workId 巡检任务信息ID
     * @return 结果
     */
    public int deleteTInspectWorkInfoById(Long workId);

    /**
     * 批量删除巡检任务信息
     * 
     * @param workIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInspectWorkInfoByIds(Long[] workIds);


    public int inserts(List<TInspectWorkInfo> list);
}
