package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.THiddenTroubleWork;
import org.apache.ibatis.annotations.Param;

/**
 * 隐患排查任务Mapper接口
 * 
 * @author zehong
 * @date 2022-07-11
 */
public interface THiddenTroubleWorkMapper 
{
    /**
     * 查询隐患排查任务
     * 
     * @param workId 隐患排查任务ID
     * @return 隐患排查任务
     */
    public THiddenTroubleWork selectTHiddenTroubleWorkById(Long workId);

    /**
     * 查询隐患排查任务列表
     * 
     * @param tHiddenTroubleWork 隐患排查任务
     * @return 隐患排查任务集合
     */
    public List<THiddenTroubleWork> selectTHiddenTroubleWorkList(THiddenTroubleWork tHiddenTroubleWork);
    public List<THiddenTroubleWork> selectTHiddenTroubleWorkListApp(THiddenTroubleWork tHiddenTroubleWork);

    /**
     * 新增隐患排查任务
     * 
     * @param tHiddenTroubleWork 隐患排查任务
     * @return 结果
     */
    public int insertTHiddenTroubleWork(THiddenTroubleWork tHiddenTroubleWork);

    /**
     * 修改隐患排查任务
     * 
     * @param tHiddenTroubleWork 隐患排查任务
     * @return 结果
     */
    public int updateTHiddenTroubleWork(THiddenTroubleWork tHiddenTroubleWork);

    /**
     * 删除隐患排查任务
     * 
     * @param workId 隐患排查任务ID
     * @return 结果
     */
    public int deleteTHiddenTroubleWorkById(Long workId);

    /**
     * 批量删除隐患排查任务
     * 
     * @param workIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTHiddenTroubleWorkByIds(Long[] workIds);
}
