package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.THiddenTroubleAssessment;
import org.apache.ibatis.annotations.Param;

/**
 * 排查评估Mapper接口
 * 
 * @author zehong
 * @date 2022-07-12
 */
public interface THiddenTroubleAssessmentMapper 
{
    /**
     * 查询排查评估
     * 
     * @param assessmentId 排查评估ID
     * @return 排查评估
     */
    public THiddenTroubleAssessment selectTHiddenTroubleAssessmentById(Long assessmentId);
    public THiddenTroubleAssessment selectTHiddenTroubleAssessmentByWorkId(Long workId);


    /**
     * 查询排查评估列表
     * 
     * @param tHiddenTroubleAssessment 排查评估
     * @return 排查评估集合
     */
    public List<THiddenTroubleAssessment> selectTHiddenTroubleAssessmentList(THiddenTroubleAssessment tHiddenTroubleAssessment);

    /**
     * 新增排查评估
     * 
     * @param tHiddenTroubleAssessment 排查评估
     * @return 结果
     */
    public int insertTHiddenTroubleAssessment(THiddenTroubleAssessment tHiddenTroubleAssessment);

    /**
     * 修改排查评估
     * 
     * @param tHiddenTroubleAssessment 排查评估
     * @return 结果
     */
    public int updateTHiddenTroubleAssessment(THiddenTroubleAssessment tHiddenTroubleAssessment);

    /**
     * 删除排查评估
     * 
     * @param assessmentId 排查评估ID
     * @return 结果
     */
    public int deleteTHiddenTroubleAssessmentById(Long assessmentId);

    /**
     * 批量删除排查评估
     * 
     * @param assessmentIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTHiddenTroubleAssessmentByIds(Long[] assessmentIds);

    public int inserts(@Param("workId")Long workId, @Param("ids")String[] ids);
}
