package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TEntranceGuardPersonInfo;

/**
 * 门禁人员信息Mapper接口
 * 
 * @author zehong
 * @date 2022-11-02
 */
public interface TEntranceGuardPersonInfoMapper 
{
    /**
     * 查询门禁人员信息
     * 
     * @param entranceGuardPersonId 门禁人员信息ID
     * @return 门禁人员信息
     */
    public TEntranceGuardPersonInfo selectTEntranceGuardPersonInfoById(Long entranceGuardPersonId);

    /**
     * 查询门禁人员信息列表
     * 
     * @param tEntranceGuardPersonInfo 门禁人员信息
     * @return 门禁人员信息集合
     */
    public List<TEntranceGuardPersonInfo> selectTEntranceGuardPersonInfoList(TEntranceGuardPersonInfo tEntranceGuardPersonInfo);

    /**
     * 新增门禁人员信息
     * 
     * @param tEntranceGuardPersonInfo 门禁人员信息
     * @return 结果
     */
    public int insertTEntranceGuardPersonInfo(TEntranceGuardPersonInfo tEntranceGuardPersonInfo);

    /**
     * 修改门禁人员信息
     * 
     * @param tEntranceGuardPersonInfo 门禁人员信息
     * @return 结果
     */
    public int updateTEntranceGuardPersonInfo(TEntranceGuardPersonInfo tEntranceGuardPersonInfo);

    /**
     * 删除门禁人员信息
     * 
     * @param entranceGuardPersonId 门禁人员信息ID
     * @return 结果
     */
    public int deleteTEntranceGuardPersonInfoById(Long entranceGuardPersonId);

    /**
     * 批量删除门禁人员信息
     * 
     * @param entranceGuardPersonIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTEntranceGuardPersonInfoByIds(Long[] entranceGuardPersonIds);

    /**
     * 统计进出人员数量
     * @return
     */
    List<Map<String,String>> statisticsPersonByActionType();

    /**
     * 统计在场人员
     * @return
     */
    String statisticsStayInPersons();

    /**
     * 获取最新进出数据
     * @return
     */
    List<TEntranceGuardPersonInfo> lastImportAndExportData();

}
