package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TDeviceInfo;

/**
 * 设备信息管理Mapper接口
 * 
 * @author zehong
 * @date 2022-07-02
 */
public interface TDeviceInfoMapper 
{
    /**
     * 查询设备信息管理
     * 
     * @param id 设备信息管理ID
     * @return 设备信息管理
     */
    public TDeviceInfo selectTDeviceInfoById(Long id);

    /**
     * 查询设备信息管理列表
     * 
     * @param tDeviceInfo 设备信息管理
     * @return 设备信息管理集合
     */
    public List<TDeviceInfo> selectTDeviceInfoList(TDeviceInfo tDeviceInfo);

    /**
     * 新增设备信息管理
     * 
     * @param tDeviceInfo 设备信息管理
     * @return 结果
     */
    public int insertTDeviceInfo(TDeviceInfo tDeviceInfo);

    /**
     * 修改设备信息管理
     * 
     * @param tDeviceInfo 设备信息管理
     * @return 结果
     */
    public int updateTDeviceInfo(TDeviceInfo tDeviceInfo);

    /**
     * 删除设备信息管理
     * 
     * @param id 设备信息管理ID
     * @return 结果
     */
    public int deleteTDeviceInfoById(Long id);

    /**
     * 批量删除设备信息管理
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDeviceInfoByIds(Long[] ids);
}
