package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TDeviceAlarmInfo;

/**
 * 报警记录Mapper接口
 * 
 * @author zehong
 * @date 2022-07-04
 */
public interface TDeviceAlarmInfoMapper 
{
    /**
     * 查询报警记录
     * 
     * @param alarmId 报警记录ID
     * @return 报警记录
     */
    public TDeviceAlarmInfo selectTDeviceAlarmInfoById(Long alarmId);

    /**
     * 查询报警记录列表
     * 
     * @param tDeviceAlarmInfo 报警记录
     * @return 报警记录集合
     */
    public List<TDeviceAlarmInfo> selectTDeviceAlarmInfoList(TDeviceAlarmInfo tDeviceAlarmInfo);

    /**
     * 新增报警记录
     * 
     * @param tDeviceAlarmInfo 报警记录
     * @return 结果
     */
    public int insertTDeviceAlarmInfo(TDeviceAlarmInfo tDeviceAlarmInfo);

    /**
     * 修改报警记录
     * 
     * @param tDeviceAlarmInfo 报警记录
     * @return 结果
     */
    public int updateTDeviceAlarmInfo(TDeviceAlarmInfo tDeviceAlarmInfo);

    /**
     * 删除报警记录
     * 
     * @param alarmId 报警记录ID
     * @return 结果
     */
    public int deleteTDeviceAlarmInfoById(Long alarmId);

    /**
     * 批量删除报警记录
     * 
     * @param alarmIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDeviceAlarmInfoByIds(Long[] alarmIds);

    /**
     * 根据类型查数量
     * @return
     */
    public List<Map<String,Object>> selectByType();
    /**
     * 根据级别查数量
     * @return
     */
    public List<Map<String,Object>> selectByLevel();

    /**
     * 根据处理状态查数量
     * @return
     */
    public List<Map<String,Object>> selectByStatus();

    /**
     * 查询近30天每天的报警数量
     * @return
     */
    public List<Map<String,Object>> selectEveryDay();

    /**
     * 预警年累计
     * @return
     */
    int sumAlarmByYear();

    /**
     * 预警月累计
     * @return
     */
    int sumAlarmByMonth();

    /**
     * 预警日累计
     * @return
     */
    int sumAlarmByDay();
}
