package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TContractorTrainResultDetail;

/**
 * 承包商及访客培训考试结果详情Mapper接口
 * 
 * @author wu
 * @date 2022-12-30
 */
public interface TContractorTrainResultDetailMapper 
{
    /**
     * 查询承包商及访客培训考试结果详情
     * 
     * @param detailId 承包商及访客培训考试结果详情ID
     * @return 承包商及访客培训考试结果详情
     */
    public TContractorTrainResultDetail selectTContractorTrainResultDetailById(Long detailId);

    /**
     * 查询承包商及访客培训考试结果详情列表
     * 
     * @param tContractorTrainResultDetail 承包商及访客培训考试结果详情
     * @return 承包商及访客培训考试结果详情集合
     */
    public List<TContractorTrainResultDetail> selectTContractorTrainResultDetailList(TContractorTrainResultDetail tContractorTrainResultDetail);

    /**
     * 新增承包商及访客培训考试结果详情
     * 
     * @param tContractorTrainResultDetail 承包商及访客培训考试结果详情
     * @return 结果
     */
    public int insertTContractorTrainResultDetail(TContractorTrainResultDetail tContractorTrainResultDetail);

    /**
     * 修改承包商及访客培训考试结果详情
     * 
     * @param tContractorTrainResultDetail 承包商及访客培训考试结果详情
     * @return 结果
     */
    public int updateTContractorTrainResultDetail(TContractorTrainResultDetail tContractorTrainResultDetail);

    /**
     * 删除承包商及访客培训考试结果详情
     * 
     * @param detailId 承包商及访客培训考试结果详情ID
     * @return 结果
     */
    public int deleteTContractorTrainResultDetailById(Long detailId);

    /**
     * 批量删除承包商及访客培训考试结果详情
     * 
     * @param detailIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTContractorTrainResultDetailByIds(Long[] detailIds);
}
