package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TContractorTrainCourseTopic;

/**
 * 承包商及访客培训题库Mapper接口
 * 
 * @author zehong
 * @date 2022-12-27
 */
public interface TContractorTrainCourseTopicMapper 
{
    /**
     * 查询承包商及访客培训题库
     * 
     * @param topicId 承包商及访客培训题库ID
     * @return 承包商及访客培训题库
     */
    public TContractorTrainCourseTopic selectTContractorTrainCourseTopicById(Long topicId);

    /**
     * 查询承包商及访客培训题库列表
     * 
     * @param tContractorTrainCourseTopic 承包商及访客培训题库
     * @return 承包商及访客培训题库集合
     */
    public List<TContractorTrainCourseTopic> selectTContractorTrainCourseTopicList(TContractorTrainCourseTopic tContractorTrainCourseTopic);

    /**
     * 新增承包商及访客培训题库
     * 
     * @param tContractorTrainCourseTopic 承包商及访客培训题库
     * @return 结果
     */
    public int insertTContractorTrainCourseTopic(TContractorTrainCourseTopic tContractorTrainCourseTopic);

    /**
     * 修改承包商及访客培训题库
     * 
     * @param tContractorTrainCourseTopic 承包商及访客培训题库
     * @return 结果
     */
    public int updateTContractorTrainCourseTopic(TContractorTrainCourseTopic tContractorTrainCourseTopic);

    /**
     * 删除承包商及访客培训题库
     * 
     * @param topicId 承包商及访客培训题库ID
     * @return 结果
     */
    public int deleteTContractorTrainCourseTopicById(Long topicId);

    /**
     * 批量删除承包商及访客培训题库
     * 
     * @param topicIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTContractorTrainCourseTopicByIds(Long[] topicIds);
}
