package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TContractorTrainCourse;

/**
 * 承包商及访客培训Mapper接口
 *
 * @author zehong
 * @date 2022-12-27
 */
public interface TContractorTrainCourseMapper
{
    /**
     * 查询承包商及访客培训
     *
     * @param contractorCourseId 承包商及访客培训ID
     * @return 承包商及访客培训
     */
    public TContractorTrainCourse selectTContractorTrainCourseById(Long contractorCourseId);

    /**
     * 查询承包商及访客培训列表
     *
     * @param tContractorTrainCourse 承包商及访客培训
     * @return 承包商及访客培训集合
     */
    public List<TContractorTrainCourse> selectTContractorTrainCourseList(TContractorTrainCourse tContractorTrainCourse);

    /**
     * 新增承包商及访客培训
     *
     * @param tContractorTrainCourse 承包商及访客培训
     * @return 结果
     */
    public int insertTContractorTrainCourse(TContractorTrainCourse tContractorTrainCourse);

    /**
     * 修改承包商及访客培训
     *
     * @param tContractorTrainCourse 承包商及访客培训
     * @return 结果
     */
    public int updateTContractorTrainCourse(TContractorTrainCourse tContractorTrainCourse);

    /**
     * 删除承包商及访客培训
     *
     * @param contractorCourseId 承包商及访客培训ID
     * @return 结果
     */
    public int deleteTContractorTrainCourseById(Long contractorCourseId);

    /**
     * 批量删除承包商及访客培训
     *
     * @param contractorCourseIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTContractorTrainCourseByIds(Long[] contractorCourseIds);

    /**
     * 查询承包商及访客培训
     * @param tContractorTrainCourse
     * @return
     */
    TContractorTrainCourse getITContractorTrainCourse(TContractorTrainCourse tContractorTrainCourse);
}
