package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TContractorPerson;
import com.zehong.system.domain.vo.TContractorPersonVo;

/**
 * 承包商人员信息Mapper接口
 * 
 * @author zehong
 * @date 2022-06-29
 */
public interface TContractorPersonMapper 
{
    /**
     * 查询承包商人员信息
     * 
     * @param id 承包商人员信息ID
     * @return 承包商人员信息
     */
    public TContractorPersonVo selectTContractorPersonById(Long id);

    /**
     * 查询承包商人员信息列表
     * 
     * @param tContractorPerson 承包商人员信息
     * @return 承包商人员信息集合
     */
    public List<TContractorPersonVo> selectTContractorPersonList(TContractorPerson tContractorPerson);

    /**
     * 新增承包商人员信息
     * 
     * @param tContractorPerson 承包商人员信息
     * @return 结果
     */
    public int insertTContractorPerson(TContractorPerson tContractorPerson);

    /**
     * 修改承包商人员信息
     * 
     * @param tContractorPerson 承包商人员信息
     * @return 结果
     */
    public int updateTContractorPerson(TContractorPerson tContractorPerson);

    /**
     * 删除承包商人员信息
     * 
     * @param id 承包商人员信息ID
     * @return 结果
     */
    public int deleteTContractorPersonById(Long id);

    /**
     * 批量删除承包商人员信息
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTContractorPersonByIds(Long[] ids);
}
