package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TContractor;

/**
 * 承包商信息Mapper接口
 * 
 * @author zehong
 * @date 2022-06-29
 */
public interface TContractorMapper 
{
    /**
     * 查询承包商信息
     * 
     * @param id 承包商信息ID
     * @return 承包商信息
     */
    public TContractor selectTContractorById(Long id);

    /**
     * 查询承包商信息列表
     * 
     * @param tContractor 承包商信息
     * @return 承包商信息集合
     */
    public List<TContractor> selectTContractorList(TContractor tContractor);

    /**
     * 新增承包商信息
     * 
     * @param tContractor 承包商信息
     * @return 结果
     */
    public int insertTContractor(TContractor tContractor);

    /**
     * 修改承包商信息
     * 
     * @param tContractor 承包商信息
     * @return 结果
     */
    public int updateTContractor(TContractor tContractor);

    /**
     * 删除承包商信息
     * 
     * @param id 承包商信息ID
     * @return 结果
     */
    public int deleteTContractorById(Long id);

    /**
     * 批量删除承包商信息
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTContractorByIds(Long[] ids);
}
