package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TBankSubject;

/**
 * 题库题目Mapper接口
 *
 * @author zehong
 * @date 2022-12-15
 */
public interface TBankSubjectMapper
{
    /**
     * 查询题库题目
     *
     * @param subjectId 题库题目ID
     * @return 题库题目
     */
    public TBankSubject selectTBankSubjectById(Long subjectId);

    /**
     * 查询题库题目列表
     *
     * @param tBankSubject 题库题目
     * @return 题库题目集合
     */
    public List<TBankSubject> selectTBankSubjectList(TBankSubject tBankSubject);

    /**
     * 新增题库题目
     *
     * @param tBankSubject 题库题目
     * @return 结果
     */
    public int insertTBankSubject(TBankSubject tBankSubject);

    /**
     * 修改题库题目
     *
     * @param tBankSubject 题库题目
     * @return 结果
     */
    public int updateTBankSubject(TBankSubject tBankSubject);

    /**
     * 删除题库题目
     *
     * @param subjectId 题库题目ID
     * @return 结果
     */
    public int deleteTBankSubjectById(Long subjectId);

    /**
     * 批量删除题库题目
     *
     * @param subjectIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTBankSubjectByIds(Long[] subjectIds);

    /**
     * Excel导入
     * @param list
     */
    void insertBank(List<TBankSubject> list);
}
