package com.zehong.system.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 设备保养计划对象 t_maintain_plan
 * 
 * @author zehong
 * @date 2022-07-04
 */
@Data
public class TMaintainPlanVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 计划名称 */
    private String planName;

    /** 计划编号 */
    private String planCode;

    /** 设备编号 */
    private String deviceId;

    /** 计划开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date planStartTime;

    /** 计划结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date planEndTime;

    /** 保养内容 */
    private String maintainContent;

    /** 计划状态（0待确认，1待验收，2验收完成） */
    private String planStatus;

    /** 是否删除（0正常，1删除） */
    private String isDel;

    /** 备注信息 */
    private String remarks;
}
