package com.zehong.system.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 作业许可证对象 t_work_permit
 * 
 * @author zehong
 * @date 2022-08-18
 */
public class TWorkPermit extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 作业许可证申请id */
    private Long workPermitId;

    /** 申请部门 */
    @Excel(name = "申请部门")
    private String applyDept;

    /** 联系人 */
    @Excel(name = "联系人")
    private String linkMan;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String linkPhone;

    /** 工作范围 */
    @Excel(name = "工作范围")
    private String workBound;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String deviceName;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String deviceNum;

    /** 申请工作开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "申请工作开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date applyWorkStartTime;

    /** 申请工作结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "申请工作结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date applyWorkEndTime;

    /** 工作内容 */
    @Excel(name = "工作内容")
    private String workContent;

    /** 承包商 */
    @Excel(name = "承包商")
    private Long contractor;

    /** 批准人 */
    @Excel(name = "批准人")
    private Long ratifier;

    /** 危险标识 */
    @Excel(name = "危险标识")
    private String mainDangerousMark;

    /** 危险标识详情 */
    @Excel(name = "危险标识详情")
    private String dangerousMarkDetial;

    /** 许可证信息 */
    @Excel(name = "许可证信息")
    private String licenceInfo;

    /** 相关方签字 */
    @Excel(name = "相关方签字")
    private String relationSign;

    /** 生产组确认 */
    @Excel(name = "生产组确认")
    private String produceComfirm;

    /** 工作批准/移交/关闭 */
    @Excel(name = "工作批准/移交/关闭")
    private String workDeal;

    /** 申请单状态 */
    @Excel(name = "申请单状态")
    private String applyStatus;

    /** 备注信息 */
    @Excel(name = "备注信息")
    private String remarks;

    private String operator;

    private List<Long> approvals;

    private long currentLoginUser;

    public long getCurrentLoginUser() {
        return currentLoginUser;
    }

    public void setCurrentLoginUser(long currentLoginUser) {
        this.currentLoginUser = currentLoginUser;
    }

    public List<Long> getApprovals() {
        return approvals;
    }

    public void setApprovals(List<Long> approvals) {
        this.approvals = approvals;
    }

    /**
     * 签字人身份
     */
    private List<String> signPerson;

    public List<String> getSignPerson() {
        return signPerson;
    }

    public void setSignPerson(List<String> signPerson) {
        this.signPerson = signPerson;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setWorkPermitId(Long workPermitId)
    {
        this.workPermitId = workPermitId;
    }

    public Long getWorkPermitId() 
    {
        return workPermitId;
    }
    public void setApplyDept(String applyDept) 
    {
        this.applyDept = applyDept;
    }

    public String getApplyDept() 
    {
        return applyDept;
    }
    public void setLinkMan(String linkMan) 
    {
        this.linkMan = linkMan;
    }

    public String getLinkMan() 
    {
        return linkMan;
    }
    public void setLinkPhone(String linkPhone) 
    {
        this.linkPhone = linkPhone;
    }

    public String getLinkPhone() 
    {
        return linkPhone;
    }
    public void setWorkBound(String workBound) 
    {
        this.workBound = workBound;
    }

    public String getWorkBound() 
    {
        return workBound;
    }
    public void setDeviceName(String deviceName) 
    {
        this.deviceName = deviceName;
    }

    public String getDeviceName() 
    {
        return deviceName;
    }
    public void setDeviceNum(String deviceNum) 
    {
        this.deviceNum = deviceNum;
    }

    public String getDeviceNum() 
    {
        return deviceNum;
    }
    public void setApplyWorkStartTime(Date applyWorkStartTime) 
    {
        this.applyWorkStartTime = applyWorkStartTime;
    }

    public Date getApplyWorkStartTime() 
    {
        return applyWorkStartTime;
    }
    public void setApplyWorkEndTime(Date applyWorkEndTime) 
    {
        this.applyWorkEndTime = applyWorkEndTime;
    }

    public Date getApplyWorkEndTime() 
    {
        return applyWorkEndTime;
    }
    public void setWorkContent(String workContent) 
    {
        this.workContent = workContent;
    }

    public String getWorkContent() 
    {
        return workContent;
    }
    public void setContractor(Long contractor) 
    {
        this.contractor = contractor;
    }

    public Long getContractor() 
    {
        return contractor;
    }
    public void setRatifier(Long ratifier) 
    {
        this.ratifier = ratifier;
    }

    public Long getRatifier() 
    {
        return ratifier;
    }
    public void setMainDangerousMark(String mainDangerousMark) 
    {
        this.mainDangerousMark = mainDangerousMark;
    }

    public String getMainDangerousMark() 
    {
        return mainDangerousMark;
    }
    public void setDangerousMarkDetial(String dangerousMarkDetial) 
    {
        this.dangerousMarkDetial = dangerousMarkDetial;
    }

    public String getDangerousMarkDetial() 
    {
        return dangerousMarkDetial;
    }
    public void setLicenceInfo(String licenceInfo) 
    {
        this.licenceInfo = licenceInfo;
    }

    public String getLicenceInfo() 
    {
        return licenceInfo;
    }
    public void setRelationSign(String relationSign) 
    {
        this.relationSign = relationSign;
    }

    public String getRelationSign() 
    {
        return relationSign;
    }
    public void setProduceComfirm(String produceComfirm) 
    {
        this.produceComfirm = produceComfirm;
    }

    public String getProduceComfirm() 
    {
        return produceComfirm;
    }
    public void setWorkDeal(String workDeal) 
    {
        this.workDeal = workDeal;
    }

    public String getWorkDeal() 
    {
        return workDeal;
    }
    public void setApplyStatus(String applyStatus) 
    {
        this.applyStatus = applyStatus;
    }

    public String getApplyStatus() 
    {
        return applyStatus;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("workPermitId", getWorkPermitId())
            .append("applyDept", getApplyDept())
            .append("linkMan", getLinkMan())
            .append("linkPhone", getLinkPhone())
            .append("workBound", getWorkBound())
            .append("deviceName", getDeviceName())
            .append("deviceNum", getDeviceNum())
            .append("applyWorkStartTime", getApplyWorkStartTime())
            .append("applyWorkEndTime", getApplyWorkEndTime())
            .append("workContent", getWorkContent())
            .append("contractor", getContractor())
            .append("ratifier", getRatifier())
            .append("mainDangerousMark", getMainDangerousMark())
            .append("dangerousMarkDetial", getDangerousMarkDetial())
            .append("licenceInfo", getLicenceInfo())
            .append("relationSign", getRelationSign())
            .append("produceComfirm", getProduceComfirm())
            .append("workDeal", getWorkDeal())
            .append("applyStatus", getApplyStatus())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
