package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 用户课程对象 t_train_user_course
 * 
 * @author zehong
 * @date 2022-09-19
 */
public class TTrainUserCourse extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 用户课程id */
    private Long userCourseId;

    /** 用户id */
    @Excel(name = "用户id")
    private Long userId;

    /** 课程id */
    @Excel(name = "课程id")
    private Long courseId;

    /** 0未学习 1未通过 2已通过 */
    @Excel(name = "0未学习 1未通过 2已通过")
    private Integer state;

    /** 最后一次考试时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "最后一次考试时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date examinationTime;

    /** 最后一次考试结果（答对数量） */
    @Excel(name = "最后一次考试结果", readConverterExp = "答=对数量")
    private Integer examinationResult;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createUser;

    
    /**人员名称**/
    private String staffName;

    /**人员部门**/
    private String deptName;

    private Integer personnelType;

    public Integer getPersonnelType() {
        return personnelType;
    }

    public void setPersonnelType(Integer personnelType) {
        this.personnelType = personnelType;
    }

    public void setUserCourseId(Long userCourseId)
    {
        this.userCourseId = userCourseId;
    }

    public Long getUserCourseId() 
    {
        return userCourseId;
    }
    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setCourseId(Long courseId) 
    {
        this.courseId = courseId;
    }

    public Long getCourseId() 
    {
        return courseId;
    }
    public void setState(Integer state) 
    {
        this.state = state;
    }

    public Integer getState() 
    {
        return state;
    }
    public void setExaminationTime(Date examinationTime) 
    {
        this.examinationTime = examinationTime;
    }

    public Date getExaminationTime() 
    {
        return examinationTime;
    }
    public void setExaminationResult(Integer examinationResult) 
    {
        this.examinationResult = examinationResult;
    }

    public Integer getExaminationResult() 
    {
        return examinationResult;
    }
    public void setCreateUser(String createUser) 
    {
        this.createUser = createUser;
    }

    public String getCreateUser() 
    {
        return createUser;
    }

    public String getStaffName() {
        return staffName;
    }

    public void setStaffName(String staffName) {
        this.staffName = staffName;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("userCourseId", getUserCourseId())
            .append("userId", getUserId())
            .append("courseId", getCourseId())
            .append("state", getState())
            .append("examinationTime", getExaminationTime())
            .append("examinationResult", getExaminationResult())
            .append("createTime", getCreateTime())
            .append("createUser", getCreateUser())
            .toString();
    }
}
