package com.zehong.system.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 培训课程对象 t_train_course
 * 
 * @author zehong
 * @date 2022-09-19
 */
public class TTrainCourse extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 课程id */
    private Long courseId;

    /** 课程名称 */
    @Excel(name = "课程名称")
    private String courseName;

    /** 课程类型（培训计划） */
    @Excel(name = "课程类型", readConverterExp = "培=训计划")
    private Long courseType;

    private String planName;

    /** 课程内容 */
    @Excel(name = "课程内容")
    private String courseConent;

    /** 0未发布 1已发布 */
    @Excel(name = "0未发布 1已发布")
    private Integer status;

    /** 发布时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "发布时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date releaseTime;

    /** 课程附件 */
    @Excel(name = "课程附件")
    private String enclosure;

    /** 课程视频 */
    @Excel(name = "课程视频")
    private String video;

    /** 答题合格数 */
    @Excel(name = "答题合格数")
    private Integer qualifiedNum;

    /** 录入题数量 */
    @Excel(name = "录入题数量")
    private Integer topicNum;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createUser;

    /** 0未删除 1已删除 */
    @Excel(name = "0未删除 1已删除")
    private Integer isDel;

    /** 数据类型：0 培训，1 考试 */
    @Excel(name = "数据类型：0 培训，1 考试")
    private String dataKind;

    /** 考试开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "考试开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date testStartTime;

    /** 考试结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "考试结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date testEndTime;

    /** 考试人员 */
    @Excel(name = "考试人员")
    private String testPersons;

    private Integer personnelType;

    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public Integer getPersonnelType() {
        return personnelType;
    }

    public void setPersonnelType(Integer personnelType) {
        this.personnelType = personnelType;
    }

    public void setCourseId(Long courseId)
    {
        this.courseId = courseId;
    }

    public Long getCourseId() 
    {
        return courseId;
    }
    public void setCourseName(String courseName) 
    {
        this.courseName = courseName;
    }

    public String getCourseName() 
    {
        return courseName;
    }
    public void setCourseType(Long courseType) 
    {
        this.courseType = courseType;
    }

    public Long getCourseType() 
    {
        return courseType;
    }
    public void setCourseConent(String courseConent) 
    {
        this.courseConent = courseConent;
    }

    public String getCourseConent() 
    {
        return courseConent;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }
    public void setReleaseTime(Date releaseTime) 
    {
        this.releaseTime = releaseTime;
    }

    public Date getReleaseTime() 
    {
        return releaseTime;
    }
    public void setEnclosure(String enclosure) 
    {
        this.enclosure = enclosure;
    }

    public String getEnclosure() 
    {
        return enclosure;
    }
    public void setVideo(String video) 
    {
        this.video = video;
    }

    public String getVideo() 
    {
        return video;
    }
    public void setQualifiedNum(Integer qualifiedNum) 
    {
        this.qualifiedNum = qualifiedNum;
    }

    public Integer getQualifiedNum() 
    {
        return qualifiedNum;
    }
    public void setTopicNum(Integer topicNum) 
    {
        this.topicNum = topicNum;
    }

    public Integer getTopicNum() 
    {
        return topicNum;
    }
    public void setCreateUser(String createUser) 
    {
        this.createUser = createUser;
    }

    public String getCreateUser() 
    {
        return createUser;
    }
    public void setIsDel(Integer isDel) 
    {
        this.isDel = isDel;
    }

    public Integer getIsDel() 
    {
        return isDel;
    }
    public void setDataKind(String dataKind)
    {
        this.dataKind = dataKind;
    }

    public String getDataKind()
    {
        return dataKind;
    }
    public void setTestStartTime(Date testStartTime)
    {
        this.testStartTime = testStartTime;
    }

    public Date getTestStartTime()
    {
        return testStartTime;
    }
    public void setTestEndTime(Date testEndTime)
    {
        this.testEndTime = testEndTime;
    }

    public Date getTestEndTime()
    {
        return testEndTime;
    }
    public void setTestPersons(String testPersons)
    {
        this.testPersons = testPersons;
    }

    public String getTestPersons()
    {
        return testPersons;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("courseId", getCourseId())
            .append("courseName", getCourseName())
            .append("courseType", getCourseType())
            .append("courseConent", getCourseConent())
            .append("status", getStatus())
            .append("releaseTime", getReleaseTime())
            .append("enclosure", getEnclosure())
            .append("video", getVideo())
            .append("qualifiedNum", getQualifiedNum())
            .append("topicNum", getTopicNum())
            .append("createTime", getCreateTime())
            .append("createUser", getCreateUser())
            .append("isDel", getIsDel())
            .append("dataKind", getDataKind())
            .append("testStartTime", getTestStartTime())
            .append("testEndTime", getTestEndTime())
            .append("testPersons", getTestPersons())
            .toString();
    }
}
