package com.zehong.system.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 隐患台账对象 t_staning_book
 * 
 * @author zehong
 * @date 2022-10-07
 */
public class TStaningBook extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long bookId;

    /** 隐患名称 */
    @Excel(name = "隐患名称")
    private String troubleName;

    /** 隐患类型 */
    @Excel(name = "隐患类型")
    private Integer troubleType;

    /** 隐患等级 */
    @Excel(name = "隐患等级")
    private Integer troubleLevel;

    /** 隐患描述 */
    @Excel(name = "隐患描述")
    private String measures;

    /** 隐患危害 */
    @Excel(name = "隐患危害")
    private String troubleHarm;

    /** 隐患上报人 */
    @Excel(name = "隐患上报人")
    private Long escalation;

    private String escalationName;

    /** 隐患上报时间 */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "隐患上报时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date findTime;

    /** 现场照片 */
    @Excel(name = "现场照片")
    private String picture;

    /** 隐患附件 */
    @Excel(name = "隐患附件")
    private String enclosure;

    /** 整改建议 */
    @Excel(name = "整改建议")
    private String proposal;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date rectificationTerm;
    /** 投入费用 */
    @Excel(name = "投入费用")
    private String investmentCost;

    /** 投入物资 */
    @Excel(name = "投入物资")
    private String investmentMaterial;

    /** 整改人 */
    @Excel(name = "整改人")
    private Long rectification;

    private String rectificationName;

    /** 整改后图片 */
    @Excel(name = "整改后图片")
    private String rectificationPictrue;

    /** 整改描述 */
    @Excel(name = "整改描述")
    private String rectificationText;

    /** 整改时间 */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "整改时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date rectificationTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /** 完成时间 */
    @Excel(name = "完成时间")
    private Long finishDay;

    /** 复查图片 */
    @Excel(name = "复查图片")
    private String inspectPictrue;

    /** 复查时间 */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "复查时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date inspectTime;

    /** 复查结果描述 */
    @Excel(name = "复查结果描述")
    private String inspectResult;

    /** 复查人 */
    @Excel(name = "复查人")
    private Long personLiable;

    private String personLiableName;

    /** 隐患状态  */
    @Excel(name = "隐患状态 ")
    private Integer state;

    /** 部门id */
    @Excel(name = "部门id")
    private Long deptId;

    private String deptName;

    /** 任务id */
    @Excel(name = "任务id")
    private Long workId;

    /** 删除 0否 1是 */
    private Integer isDel;


    private List<Long> deptList;

    public List<Long> getDeptList() {
        return deptList;
    }

    public void setDeptList(List<Long> deptList) {
        this.deptList = deptList;
    }

    public String getEscalationName() {
        return escalationName;
    }

    public void setEscalationName(String escalationName) {
        this.escalationName = escalationName;
    }

    public String getRectificationName() {
        return rectificationName;
    }

    public void setRectificationName(String rectificationName) {
        this.rectificationName = rectificationName;
    }

    public String getPersonLiableName() {
        return personLiableName;
    }

    public void setPersonLiableName(String personLiableName) {
        this.personLiableName = personLiableName;
    }

    public Date getRectificationTerm() {
        return rectificationTerm;
    }

    public void setRectificationTerm(Date rectificationTerm) {
        this.rectificationTerm = rectificationTerm;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setBookId(Long bookId)
    {
        this.bookId = bookId;
    }

    public Long getBookId() 
    {
        return bookId;
    }
    public void setTroubleName(String troubleName) 
    {
        this.troubleName = troubleName;
    }

    public String getTroubleName() 
    {
        return troubleName;
    }
    public void setTroubleType(Integer troubleType) 
    {
        this.troubleType = troubleType;
    }

    public Integer getTroubleType() 
    {
        return troubleType;
    }
    public void setTroubleLevel(Integer troubleLevel) 
    {
        this.troubleLevel = troubleLevel;
    }

    public Integer getTroubleLevel() 
    {
        return troubleLevel;
    }
    public void setMeasures(String measures) 
    {
        this.measures = measures;
    }

    public String getMeasures() 
    {
        return measures;
    }
    public void setTroubleHarm(String troubleHarm) 
    {
        this.troubleHarm = troubleHarm;
    }

    public String getTroubleHarm() 
    {
        return troubleHarm;
    }
    public void setEscalation(Long escalation) 
    {
        this.escalation = escalation;
    }

    public Long getEscalation() 
    {
        return escalation;
    }
    public void setFindTime(Date findTime) 
    {
        this.findTime = findTime;
    }

    public Date getFindTime() 
    {
        return findTime;
    }
    public void setPicture(String picture) 
    {
        this.picture = picture;
    }

    public String getPicture() 
    {
        return picture;
    }
    public void setEnclosure(String enclosure) 
    {
        this.enclosure = enclosure;
    }

    public String getEnclosure() 
    {
        return enclosure;
    }
    public void setProposal(String proposal) 
    {
        this.proposal = proposal;
    }

    public String getProposal() 
    {
        return proposal;
    }
    public void setInvestmentCost(String investmentCost) 
    {
        this.investmentCost = investmentCost;
    }

    public String getInvestmentCost() 
    {
        return investmentCost;
    }
    public void setInvestmentMaterial(String investmentMaterial) 
    {
        this.investmentMaterial = investmentMaterial;
    }

    public String getInvestmentMaterial() 
    {
        return investmentMaterial;
    }
    public void setRectification(Long rectification) 
    {
        this.rectification = rectification;
    }

    public Long getRectification() 
    {
        return rectification;
    }
    public void setRectificationPictrue(String rectificationPictrue) 
    {
        this.rectificationPictrue = rectificationPictrue;
    }

    public String getRectificationPictrue() 
    {
        return rectificationPictrue;
    }
    public void setRectificationText(String rectificationText) 
    {
        this.rectificationText = rectificationText;
    }

    public String getRectificationText() 
    {
        return rectificationText;
    }
    public void setRectificationTime(Date rectificationTime) 
    {
        this.rectificationTime = rectificationTime;
    }

    public Date getRectificationTime() 
    {
        return rectificationTime;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }
    public void setFinishDay(Long finishDay) 
    {
        this.finishDay = finishDay;
    }

    public Long getFinishDay() 
    {
        return finishDay;
    }
    public void setInspectPictrue(String inspectPictrue) 
    {
        this.inspectPictrue = inspectPictrue;
    }

    public String getInspectPictrue() 
    {
        return inspectPictrue;
    }
    public void setInspectTime(Date inspectTime) 
    {
        this.inspectTime = inspectTime;
    }

    public Date getInspectTime() 
    {
        return inspectTime;
    }
    public void setInspectResult(String inspectResult) 
    {
        this.inspectResult = inspectResult;
    }

    public String getInspectResult() 
    {
        return inspectResult;
    }
    public void setPersonLiable(Long personLiable) 
    {
        this.personLiable = personLiable;
    }

    public Long getPersonLiable() 
    {
        return personLiable;
    }
    public void setState(Integer state) 
    {
        this.state = state;
    }

    public Integer getState() 
    {
        return state;
    }
    public void setDeptId(Long deptId) 
    {
        this.deptId = deptId;
    }

    public Long getDeptId() 
    {
        return deptId;
    }
    public void setWorkId(Long workId) 
    {
        this.workId = workId;
    }

    public Long getWorkId() 
    {
        return workId;
    }
    public void setIsDel(Integer isDel) 
    {
        this.isDel = isDel;
    }

    public Integer getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("bookId", getBookId())
            .append("troubleName", getTroubleName())
            .append("troubleType", getTroubleType())
            .append("troubleLevel", getTroubleLevel())
            .append("measures", getMeasures())
            .append("troubleHarm", getTroubleHarm())
            .append("escalation", getEscalation())
            .append("findTime", getFindTime())
            .append("picture", getPicture())
            .append("enclosure", getEnclosure())
            .append("proposal", getProposal())
            .append("investmentCost", getInvestmentCost())
            .append("investmentMaterial", getInvestmentMaterial())
            .append("rectification", getRectification())
            .append("rectificationPictrue", getRectificationPictrue())
            .append("rectificationText", getRectificationText())
            .append("rectificationTime", getRectificationTime())
            .append("remarks", getRemarks())
            .append("finishDay", getFinishDay())
            .append("inspectPictrue", getInspectPictrue())
            .append("inspectTime", getInspectTime())
            .append("inspectResult", getInspectResult())
            .append("personLiable", getPersonLiable())
            .append("state", getState())
            .append("deptId", getDeptId())
            .append("workId", getWorkId())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .append("isDel", getIsDel())
            .toString();
    }
}
