package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.List;

/**
 * 特殊作业许可证对象 t_special_work_permit
 * 
 * @author zehong
 * @date 2022-08-25
 */
public class TSpecialWorkPermit extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 特殊作业许可证id */
    private Long specialWorkPermitId;

    /** 作业证id */
    @Excel(name = "作业证id")
    private Long workPermitId;

    /** 作业证编号 */
    @Excel(name = "作业证编号")
    private String licenceNum;

    /** 特殊作业证类型： blindPlate:盲板抽堵安全作业证,flareUp：动火安全作业证,heightWork：高处安全作业证,breakGround：动土安全作业证,limitSpace：受限空间安全作业证,electricityUse：临时用电安全作业证,ray： 射线安全作业证,hoisting:吊装安全作业证 */
    @Excel(name = "特殊作业证类型： blindPlate:盲板抽堵安全作业证,flareUp：动火安全作业证,heightWork：高处安全作业证,breakGround：动土安全作业证,limitSpace：受限空间安全作业证,electricityUse：临时用电安全作业证,ray： 射线安全作业证,hoisting:吊装安全作业证")
    private String specialWorkType;

    /** 特殊作业证内容 */
    @Excel(name = "特殊作业证内容")
    private String specialWorkData;

    private String isDel;

    /** 备注信息 */
    @Excel(name = "备注信息")
    private String remarks;

    private List<TSpecialWorkPermitSign> signs;

    public List<TSpecialWorkPermitSign> getSigns() {
        return signs;
    }

    public void setSigns(List<TSpecialWorkPermitSign> signs) {
        this.signs = signs;
    }

    public void setSpecialWorkPermitId(Long specialWorkPermitId)
    {
        this.specialWorkPermitId = specialWorkPermitId;
    }

    public Long getSpecialWorkPermitId() 
    {
        return specialWorkPermitId;
    }
    public void setWorkPermitId(Long workPermitId) 
    {
        this.workPermitId = workPermitId;
    }

    public Long getWorkPermitId() 
    {
        return workPermitId;
    }
    public void setLicenceNum(String licenceNum) 
    {
        this.licenceNum = licenceNum;
    }

    public String getLicenceNum() 
    {
        return licenceNum;
    }
    public void setSpecialWorkType(String specialWorkType) 
    {
        this.specialWorkType = specialWorkType;
    }

    public String getSpecialWorkType() 
    {
        return specialWorkType;
    }
    public void setSpecialWorkData(String specialWorkData) 
    {
        this.specialWorkData = specialWorkData;
    }

    public String getSpecialWorkData() 
    {
        return specialWorkData;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("specialWorkPermitId", getSpecialWorkPermitId())
            .append("workPermitId", getWorkPermitId())
            .append("licenceNum", getLicenceNum())
            .append("specialWorkType", getSpecialWorkType())
            .append("specialWorkData", getSpecialWorkData())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
