package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 特种设备台账对象 t_special_device_record
 * 
 * @author zehong
 * @date 2022-07-02
 */
public class TSpecialDeviceRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 记录编号 */
    private String operateCode;

    /** 对应类型 */
    @Excel(name = "对应类型")
    private String operateType;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String deviceCode;

    /** 设备id */
    private Long deviceId;

    /** 登记有效日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "登记有效日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date effectiveDate;

    /** 维修保养记录状态 */
    @Excel(name = "维修保养记录状态")
    private String recordStatus;

    /** 是否删除 */
    private String isDel;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public String getOperateCode() {
        return operateCode;
    }

    public void setOperateCode(String operateCode) {
        this.operateCode = operateCode;
    }

    public void setDeviceCode(String deviceCode)
    {
        this.deviceCode = deviceCode;
    }

    public String getDeviceCode() 
    {
        return deviceCode;
    }

    public Long getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public String getOperateType() {
        return operateType;
    }

    public void setOperateType(String operateType) {
        this.operateType = operateType;
    }

    public void setEffectiveDate(Date effectiveDate)
    {
        this.effectiveDate = effectiveDate;
    }

    public Date getEffectiveDate() 
    {
        return effectiveDate;
    }

    public String getRecordStatus() {
        return recordStatus;
    }

    public void setRecordStatus(String recordStatus) {
        this.recordStatus = recordStatus;
    }

    public String getIsDel() {
        return isDel;
    }

    public void setIsDel(String isDel) {
        this.isDel = isDel;
    }
}
