package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 安全承诺公告对象 t_safety_commitment_announcement
 * 
 * @author zehong
 * @date 2022-12-21
 */
@Data
public class TSafetyCommitmentAnnouncement extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 安全承诺公告id */
    private Long id;

    /** 生产装置 */
    @Excel(name = "生产装置")
    private Long productionUnit;

    /** 运行装置 */
    @Excel(name = "运行装置")
    private Long runningDevice;

    /** 停产装置 */
    @Excel(name = "停产装置")
    private Long shutdownDevice;

    /** 检修装置 */
    @Excel(name = "检修装置")
    private Long maintenanceDevice;

    /** 动火作业 */
    @Excel(name = "动火作业")
    private Long hotWork;

    /** 特殊动火作业 */
    @Excel(name = "特殊动火作业")
    private Long specialHotWork;

    /** 一级动火作业 */
    @Excel(name = "一级动火作业")
    private Long classOneHotWork;

    /** 二级动火作业 */
    @Excel(name = "二级动火作业")
    private Long classTwoHotWork;

    /** 是否受限空间作业（0是，1否） */
    @Excel(name = "是否受限空间作业", readConverterExp = "0=是，1否")
    private String isConfinedSpace;

    /** 是否试生产（0是，1否） */
    @Excel(name = "是否试生产", readConverterExp = "0=是，1否")
    private String isTrialProduction;

    /** 罐装、仓库等重大危险源是否处于安全状态（0是，1否） */
    @Excel(name = "罐装、仓库等重大危险源是否处于安全状态", readConverterExp = "0=是，1否")
    private String isSecurityStatus;

    /** 风险等级 */
    @Excel(name = "风险等级")
    private String assessmentLevel;

    /** 主要负责人 */
    @Excel(name = "主要负责人")
    private String keyPerson;

    /** 承诺公告 */
    @Excel(name = "承诺公告")
    private String announcement;

    private String status;

    /** 承诺日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "承诺日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date commitmentDate;
}
