package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 风险信息对象 t_risk_manager
 *
 * @author zehong
 * @date 2022-11-24
 */
public class TRiskManager extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 辨识部位 */
    @Excel(name = "辨识部位")
    private String riskPart;

    /** 存在风险 */
    @Excel(name = "存在风险")
    private String riskContent;

    /** 风险等级 */
    @Excel(name = "风险等级")
    private String riskLevel;

    /** 事故类型 */
    @Excel(name = "事故类型")
    private String riskType;

    /** 管控措施 */
    @Excel(name = "管控措施")
    private String riskControl;

    /** 责任部门 */
    @Excel(name = "责任部门")
    private Long riskDept;

    /** 责任人 */
    @Excel(name = "责任人")
    private String riskPerson;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setRiskPart(String riskPart)
    {
        this.riskPart = riskPart;
    }

    public String getRiskPart()
    {
        return riskPart;
    }
    public void setRiskContent(String riskContent)
    {
        this.riskContent = riskContent;
    }

    public String getRiskContent()
    {
        return riskContent;
    }
    public void setRiskLevel(String riskLevel)
    {
        this.riskLevel = riskLevel;
    }

    public String getRiskLevel()
    {
        return riskLevel;
    }
    public void setRiskType(String riskType)
    {
        this.riskType = riskType;
    }

    public String getRiskType()
    {
        return riskType;
    }
    public void setRiskControl(String riskControl)
    {
        this.riskControl = riskControl;
    }

    public String getRiskControl()
    {
        return riskControl;
    }
    public void setRiskDept(Long riskDept)
    {
        this.riskDept = riskDept;
    }

    public Long getRiskDept()
    {
        return riskDept;
    }
    public void setRiskPerson(String riskPerson)
    {
        this.riskPerson = riskPerson;
    }

    public String getRiskPerson()
    {
        return riskPerson;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("riskPart", getRiskPart())
                .append("riskContent", getRiskContent())
                .append("riskLevel", getRiskLevel())
                .append("riskType", getRiskType())
                .append("riskControl", getRiskControl())
                .append("riskDept", getRiskDept())
                .append("riskPerson", getRiskPerson())
                .toString();
    }
}
