package com.zehong.system.domain;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * setting对象 t_nfc_setting
 *
 * @author zehong
 * @date 2022-10-17
 */
public class TNfcSetting extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** nfc_id */
    private Long nfcId;

    private Long TNfcSetting;

    /** 排序 */
    @Excel(name = "排序")
    private Integer patrolSort;

    /** 巡检地点 */
    @Excel(name = "巡检地点")
    private String patrolAddress;

    /** 巡检内容 */
    @Excel(name = "巡检内容")
    private String patrolComent;

    /** 巡检频次 */
    @Excel(name = "巡检频次")
    private String patrolFrequency;

    /** nfc编号 */
    @Excel(name = "nfc编号")
    private String nfcNum;

    /** 是否删除 0否 1是 */
    private Integer isDel;

    /**
     * 区域 编号
     */
    private String region;

    /**
     * 巡检区域
     */
    private String nickName;

    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String applyWorkStartTime;

    /**
     * 结束时间
     * @return
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String applyWorkEndTime;

    public Long getTNfcSetting() {
        return TNfcSetting;
    }

    public void setTNfcSetting(Long TNfcSetting) {
        this.TNfcSetting = TNfcSetting;
    }

    public String getApplyWorkStartTime() {
        return applyWorkStartTime;
    }

    public void setApplyWorkStartTime(String applyWorkStartTime) {
        this.applyWorkStartTime = applyWorkStartTime;
    }

    public String getApplyWorkEndTime() {
        return applyWorkEndTime;
    }

    public void setApplyWorkEndTime(String applyWorkEndTime) {
        this.applyWorkEndTime = applyWorkEndTime;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setNfcId(Long nfcId)
    {
        this.nfcId = nfcId;
    }

    public Long getNfcId()
    {
        return nfcId;
    }
    public void setPatrolSort(Integer patrolSort)
    {
        this.patrolSort = patrolSort;
    }

    public Integer getPatrolSort()
    {
        return patrolSort;
    }
    public void setPatrolAddress(String patrolAddress)
    {
        this.patrolAddress = patrolAddress;
    }

    public String getPatrolAddress()
    {
        return patrolAddress;
    }
    public void setPatrolComent(String patrolComent)
    {
        this.patrolComent = patrolComent;
    }

    public String getPatrolComent()
    {
        return patrolComent;
    }
    public void setPatrolFrequency(String patrolFrequency)
    {
        this.patrolFrequency = patrolFrequency;
    }

    public String getPatrolFrequency()
    {
        return patrolFrequency;
    }
    public void setNfcNum(String nfcNum)
    {
        this.nfcNum = nfcNum;
    }

    public String getNfcNum()
    {
        return nfcNum;
    }
    public void setIsDel(Integer isDel)
    {
        this.isDel = isDel;
    }

    public Integer getIsDel()
    {
        return isDel;
    }

    @Override
    public String toString() {
        return "TNfcSetting{" +
                "nfcId=" + nfcId +
                ", patrolSort=" + patrolSort +
                ", patrolAddress='" + patrolAddress + '\'' +
                ", patrolComent='" + patrolComent + '\'' +
                ", patrolFrequency='" + patrolFrequency + '\'' +
                ", nfcNum='" + nfcNum + '\'' +
                ", isDel=" + isDel +
                ", region='" + region + '\'' +
                ", nickName='" + nickName + '\'' +
                ", applyWorkStartTime=" + applyWorkStartTime +
                ", applyWorkEndTime=" + applyWorkEndTime +
                '}';
    }
}
