package com.zehong.system.domain;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import java.util.Date;

/**
 * nfc巡检记录id对象 t_nfc_record
 *
 * @author zehong
 * @date 2022-10-18
 */
public class TNfcRecord extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 巡检记录
     */
    private Long recordId;

    /**
     * nfc_id
     */
    private Long nfcId;

    /**
     * 图片地址
     */
    private String picture;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 上报人姓名
     */
    private Long createUser;

    /**巡检地点*/
    @Excel(name = "巡检地点")
    private String patrolAddress;

    /**巡检区域*/
    @Excel(name = "巡检区域")
    private String dictLabel;

    /**巡检内容*/
    @Excel(name = "巡检内容")
    private String  patrolComent;

    /**巡检频次*/
    @Excel(name = "巡检频次")
    private String patrolFrequency;

    /** 巡检人*/
    @Excel(name = "上报人")
    private String nickName;

    private String userName;

    private String startTime;

    private String endTime;

    /**
     * 是否正常 0否 1是
     */
    @Excel(name = "巡检结果", readConverterExp = "0=异常,1=正常")
    private Integer isNormal;

    /**上报时间*/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "上报时间",dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String applyWorkStartTime;

    /**
     * 结束时间
     * @return
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String applyWorkEndTime;


    public String getApplyWorkStartTime() {
        return applyWorkStartTime;
    }

    public void setApplyWorkStartTime(String applyWorkStartTime) {
        this.applyWorkStartTime = applyWorkStartTime;
    }

    public String getApplyWorkEndTime() {
        return applyWorkEndTime;
    }

    public void setApplyWorkEndTime(String applyWorkEndTime) {
        this.applyWorkEndTime = applyWorkEndTime;
    }

    public String getDictLabel() {
        return dictLabel;
    }

    public void setDictLabel(String dictLabel) {
        this.dictLabel = dictLabel;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getPatrolAddress() {
        return patrolAddress;
    }

    public void setPatrolAddress(String patrolAddress) {
        this.patrolAddress = patrolAddress;
    }

    public String getPatrolComent() {
        return patrolComent;
    }

    public void setPatrolComent(String patrolComent) {
        this.patrolComent = patrolComent;
    }

    public String getPatrolFrequency() {
        return patrolFrequency;
    }

    public void setPatrolFrequency(String patrolFrequency) {
        this.patrolFrequency = patrolFrequency;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public Long getNfcId() {
        return nfcId;
    }

    public void setNfcId(Long nfcId) {
        this.nfcId = nfcId;
    }

    public Integer getIsNormal() {
        return isNormal;
    }

    public void setIsNormal(Integer isNormal) {
        this.isNormal = isNormal;
    }

    public String getPicture() {
        return picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    @Override
    public String toString() {
        return "TNfcRecord{" +
                "recordId=" + recordId +
                ", nfcId=" + nfcId +
                ", isNormal=" + isNormal +
                ", picture='" + picture + '\'' +
                ", remarks='" + remarks + '\'' +
                ", createTime=" + createTime +
                ", createUser=" + createUser +
                ", patrolAddress='" + patrolAddress + '\'' +
                ", patrolComent='" + patrolComent + '\'' +
                ", patrolFrequency='" + patrolFrequency + '\'' +
                ", nickName='" + nickName + '\'' +
                ", userName='" + userName + '\'' +
                ", startTime='" + startTime + '\'' +
                ", endTime='" + endTime + '\'' +
                ", dictLabel='" + dictLabel + '\'' +
                '}';
    }
}


