package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 应急物资管理对象 t_material_info
 *
 * @author zehong
 * @date 2022-07-01
 */
public class TMaterialInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 物资名称 */
    @Excel(name = "物资名称")
    private String materialName;

    /** 分类 */
    @Excel(name = "分类")
    private Integer materialType;

    /** 物资数量 */
    @Excel(name = "物资数量")
    private Integer num;

    /** 性能 */
    @Excel(name = "性能")
    private String performance;

    /** 用途 */
    @Excel(name = "用途")
    private String purpose;

    /** 有效时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "有效时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date validityTime;

    /** 所属部门 */
    @Excel(name = "所属部门")
    private Long deptId;

    /** 经度 */
    @Excel(name = "经度")
    private String longitude;

    /** 维度 */
    @Excel(name = "维度")
    private String latitude;

    /** 地址信息 */
    @Excel(name = "地址信息")
    private String address;

    /** 联系人 */
    @Excel(name = "联系人")
    private String contacts;

    /** 手机号 */
    @Excel(name = "手机号")
    private String phone;

    /**责任部门*/
    private String deptName;

    /** 0未删除 1已删除 */
    private Integer isDelete;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setMaterialName(String materialName)
    {
        this.materialName = materialName;
    }

    public String getMaterialName()
    {
        return materialName;
    }
    public void setMaterialType(Integer materialType)
    {
        this.materialType = materialType;
    }

    public Integer getMaterialType()
    {
        return materialType;
    }
    public void setNum(Integer num)
    {
        this.num = num;
    }

    public Integer getNum()
    {
        return num;
    }
    public void setPerformance(String performance)
    {
        this.performance = performance;
    }

    public String getPerformance()
    {
        return performance;
    }
    public void setPurpose(String purpose)
    {
        this.purpose = purpose;
    }

    public String getPurpose()
    {
        return purpose;
    }
    public void setValidityTime(Date validityTime)
    {
        this.validityTime = validityTime;
    }

    public Date getValidityTime()
    {
        return validityTime;
    }
    public void setDeptId(Long deptId)
    {
        this.deptId = deptId;
    }

    public Long getDeptId()
    {
        return deptId;
    }
    public void setLongitude(String longitude)
    {
        this.longitude = longitude;
    }

    public String getLongitude()
    {
        return longitude;
    }
    public void setLatitude(String latitude)
    {
        this.latitude = latitude;
    }

    public String getLatitude()
    {
        return latitude;
    }
    public void setAddress(String address)
    {
        this.address = address;
    }

    public String getAddress()
    {
        return address;
    }
    public void setContacts(String contacts)
    {
        this.contacts = contacts;
    }

    public String getContacts()
    {
        return contacts;
    }
    public void setPhone(String phone)
    {
        this.phone = phone;
    }

    public String getPhone()
    {
        return phone;
    }
    public void setIsDelete(Integer isDelete)
    {
        this.isDelete = isDelete;
    }

    public Integer getIsDelete()
    {
        return isDelete;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("materialName", getMaterialName())
            .append("materialType", getMaterialType())
            .append("num", getNum())
            .append("performance", getPerformance())
            .append("purpose", getPurpose())
            .append("validityTime", getValidityTime())
            .append("deptId", getDeptId())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("address", getAddress())
            .append("contacts", getContacts())
            .append("phone", getPhone())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("isDelete", getIsDelete())
            .toString();
    }
}
