package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 投入台账对象 t_investment
 * 
 * @author zehong
 * @date 2022-06-24
 */
public class TInvestment extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 投入台账名称 */
    @Excel(name = "投入台账名称")
    private String investmentName;

    /** 投入年度 */
    @Excel(name = "投入年度")
    @JsonFormat(pattern = "yyyy")
    private short investmentYear;

    /** 投入资金 */
    @Excel(name = "投入资金")
    private String investmentFunds;

    /** 投入类型 */
    @Excel(name = "投入类型")
    private String investmentType;

    /** 同期收入 */
    @Excel(name = "同期收入")
    private String income;

    /** 提取方式 */
    @Excel(name = "提取方式")
    private String drawType;

    /** 周/月/季度 */
    @Excel(name = "周/月/季度")
    private String timeUnit;

    /** 评价 */
    @Excel(name = "评价")
    private String evaluate;

    /** 项目名称 */
    @Excel(name = "项目名称")
    private String projectName;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setInvestmentName(String investmentName) 
    {
        this.investmentName = investmentName;
    }

    public String getInvestmentName() 
    {
        return investmentName;
    }
    public void setInvestmentYear(short investmentYear)
    {
        this.investmentYear = investmentYear;
    }

    public short getInvestmentYear()
    {
        return investmentYear;
    }
    public void setInvestmentFunds(String investmentFunds) 
    {
        this.investmentFunds = investmentFunds;
    }

    public String getInvestmentFunds() 
    {
        return investmentFunds;
    }
    public void setInvestmentType(String investmentType) 
    {
        this.investmentType = investmentType;
    }

    public String getInvestmentType() 
    {
        return investmentType;
    }
    public void setIncome(String income) 
    {
        this.income = income;
    }

    public String getIncome() 
    {
        return income;
    }
    public void setDrawType(String drawType) 
    {
        this.drawType = drawType;
    }

    public String getDrawType() 
    {
        return drawType;
    }
    public void setTimeUnit(String timeUnit) 
    {
        this.timeUnit = timeUnit;
    }

    public String getTimeUnit() 
    {
        return timeUnit;
    }
    public void setEvaluate(String evaluate) 
    {
        this.evaluate = evaluate;
    }

    public String getEvaluate() 
    {
        return evaluate;
    }
    public void setProjectName(String projectName) 
    {
        this.projectName = projectName;
    }

    public String getProjectName() 
    {
        return projectName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("investmentName", getInvestmentName())
            .append("investmentYear", getInvestmentYear())
            .append("investmentFunds", getInvestmentFunds())
            .append("investmentType", getInvestmentType())
            .append("income", getIncome())
            .append("drawType", getDrawType())
            .append("timeUnit", getTimeUnit())
            .append("evaluate", getEvaluate())
            .append("projectName", getProjectName())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
