package com.zehong.system.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 巡检任务信息对象 t_inspect_work_info
 * 
 * @author zehong
 * @date 2022-06-20
 */
public class TInspectWorkInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 计划/任务id */
    private Long workId;

    /** 1单次 2每天 3每周 4每月 5每季度 */
    @Excel(name = "巡检类型")
    private Integer workType;

    /** 计划id（计划0） */
    private Long parentId;

    /** 任务名称 */
    @Excel(name = "任务名称")
    private String workName;

    /** 任务开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "任务开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm")
    private Date workBeginTime;

    /** 任务截止时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "任务截止时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm")
    private Date workLimitTime;

    /** 任务描述 */
    @Excel(name = "任务描述")
    private String workDescribe;

    /** 巡检点多个 */
    @Excel(name = "巡检点多个")
    private String pantrolId;

    @Excel(name = "部门id")
    private long deptId;
    @Excel(name = "部门名称")
    private String deptName;

    /** 检测点数量 */
    @Excel(name = "检测点数量")
    private Integer inspectPointNum;

    /** 检测完成数量 */
    @Excel(name = "检测完成数量")
    private Integer inspectSuccessNum;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    private List<TInspectWorkInfo> children;

    public List<TInspectWorkInfo> getChildren() {
        return children;
    }

    public void setChildren(List<TInspectWorkInfo> children) {
        this.children = children;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public long getDeptId() {
        return deptId;
    }

    public void setDeptId(long deptId) {
        this.deptId = deptId;
    }

    public void setWorkId(Long workId)
    {
        this.workId = workId;
    }

    public Long getWorkId() 
    {
        return workId;
    }
    public void setWorkType(Integer workType) 
    {
        this.workType = workType;
    }

    public Integer getWorkType() 
    {
        return workType;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public void setWorkName(String workName)
    {
        this.workName = workName;
    }

    public String getWorkName() 
    {
        return workName;
    }
    public void setWorkBeginTime(Date workBeginTime) 
    {
        this.workBeginTime = workBeginTime;
    }

    public Date getWorkBeginTime() 
    {
        return workBeginTime;
    }
    public void setWorkLimitTime(Date workLimitTime) 
    {
        this.workLimitTime = workLimitTime;
    }

    public Date getWorkLimitTime() 
    {
        return workLimitTime;
    }
    public void setWorkDescribe(String workDescribe) 
    {
        this.workDescribe = workDescribe;
    }

    public String getWorkDescribe() 
    {
        return workDescribe;
    }
    public void setPantrolId(String pantrolId) 
    {
        this.pantrolId = pantrolId;
    }

    public String getPantrolId() 
    {
        return pantrolId;
    }
    public void setInspectPointNum(Integer inspectPointNum) 
    {
        this.inspectPointNum = inspectPointNum;
    }

    public Integer getInspectPointNum() 
    {
        return inspectPointNum;
    }
    public void setInspectSuccessNum(Integer inspectSuccessNum) 
    {
        this.inspectSuccessNum = inspectSuccessNum;
    }

    public Integer getInspectSuccessNum() 
    {
        return inspectSuccessNum;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("workId", getWorkId())
            .append("workType", getWorkType())
            .append("parentId", getParentId())
            .append("workName", getWorkName())
            .append("workBeginTime", getWorkBeginTime())
            .append("workLimitTime", getWorkLimitTime())
            .append("workDescribe", getWorkDescribe())
            .append("pantrolId", getPantrolId())
            .append("inspectPointNum", getInspectPointNum())
            .append("inspectSuccessNum", getInspectSuccessNum())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
