package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 隐患排查库对象 t_hidden_library
 * 
 * @author zehong
 * @date 2022-12-12
 */
public class THiddenLibrary extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long libraryId;

    /** 部门id */
    @Excel(name = "部门id")
    private Long deptId;

    private String deptName;

    /** 风险点 */
    @Excel(name = "风险点")
    private String riskPoint;

    /** 检查项目 */
    @Excel(name = "检查项目")
    private String inspectTerm;

    /** 检查依据 */
    @Excel(name = "检查依据")
    private String inspectBasis;

    /** 排查库标题 */
    @Excel(name = "排查库标题")
    private String libraryName;

    /** 内容以及标准 */
    @Excel(name = "内容以及标准")
    private String libraryContent;

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setLibraryId(Long libraryId)
    {
        this.libraryId = libraryId;
    }

    public Long getLibraryId() 
    {
        return libraryId;
    }
    public void setDeptId(Long deptId) 
    {
        this.deptId = deptId;
    }

    public Long getDeptId() 
    {
        return deptId;
    }
    public void setRiskPoint(String riskPoint) 
    {
        this.riskPoint = riskPoint;
    }

    public String getRiskPoint() 
    {
        return riskPoint;
    }
    public void setInspectTerm(String inspectTerm) 
    {
        this.inspectTerm = inspectTerm;
    }

    public String getInspectTerm() 
    {
        return inspectTerm;
    }
    public void setInspectBasis(String inspectBasis) 
    {
        this.inspectBasis = inspectBasis;
    }

    public String getInspectBasis() 
    {
        return inspectBasis;
    }
    public void setLibraryName(String libraryName) 
    {
        this.libraryName = libraryName;
    }

    public String getLibraryName() 
    {
        return libraryName;
    }
    public void setLibraryContent(String libraryContent) 
    {
        this.libraryContent = libraryContent;
    }

    public String getLibraryContent() 
    {
        return libraryContent;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("libraryId", getLibraryId())
            .append("deptId", getDeptId())
            .append("riskPoint", getRiskPoint())
            .append("inspectTerm", getInspectTerm())
            .append("inspectBasis", getInspectBasis())
            .append("libraryName", getLibraryName())
            .append("libraryContent", getLibraryContent())
            .toString();
    }
}
