package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 门禁人员信息对象 t_entrance_guard_person_info
 * 
 * @author zehong
 * @date 2022-11-02
 */
public class TEntranceGuardPersonInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 门禁人员id */
    private Long entranceGuardPersonId;

    /** 姓名 */
    @Excel(name = "姓名")
    private String personName;

    /** 人员编号 */
    @Excel(name = "人员编号")
    private String personNum;

    /** 行为类型：0.进场 1.出场 */
    @Excel(name = "行为类型：0.进场 1.出场")
    private String actionType;

    /** 进出场时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "进出场时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date actionTime;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    public void setEntranceGuardPersonId(Long entranceGuardPersonId) 
    {
        this.entranceGuardPersonId = entranceGuardPersonId;
    }

    public Long getEntranceGuardPersonId() 
    {
        return entranceGuardPersonId;
    }
    public void setPersonName(String personName) 
    {
        this.personName = personName;
    }

    public String getPersonName() 
    {
        return personName;
    }
    public void setPersonNum(String personNum) 
    {
        this.personNum = personNum;
    }

    public String getPersonNum() 
    {
        return personNum;
    }
    public void setActionType(String actionType) 
    {
        this.actionType = actionType;
    }

    public String getActionType() 
    {
        return actionType;
    }
    public void setActionTime(Date actionTime) 
    {
        this.actionTime = actionTime;
    }

    public Date getActionTime() 
    {
        return actionTime;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("entranceGuardPersonId", getEntranceGuardPersonId())
            .append("personName", getPersonName())
            .append("personNum", getPersonNum())
            .append("actionType", getActionType())
            .append("actionTime", getActionTime())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
