package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 企业基础信息管理对象 t_enterprise_info
 * 
 * @author zehong
 * @date 2022-06-23
 */
public class TEnterpriseInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 单位名称 */
    @Excel(name = "单位名称")
    private String unitName;

    /** 社会统一信用代码 */
    @Excel(name = "社会统一信用代码")
    private String orgCode;

    /** 生产经营地址 */
    @Excel(name = "生产经营地址")
    private String runAddress;

    /** 注册地址 */
    @Excel(name = "注册地址")
    private String regAddress;

    /** 安全监管分类 */
    @Excel(name = "安全监管分类")
    private String regulationType;

    /** 成立日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "成立日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date regDate;

    /** 营业期限 */
    @Excel(name = "营业期限")
    private String businessTerm;

    /** 值班电话 */
    @Excel(name = "值班电话")
    private String dutyPhone;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 经营范围 */
    @Excel(name = "经营范围")
    private String businessScope;

    /** 从业人员数量 */
    @Excel(name = "从业人员数量")
    private String employeeNum;

    /** 法定代表人 */
    @Excel(name = "法定代表人")
    private String legalPerson;

    /** 法定代表人手机 */
    @Excel(name = "法定代表人手机")
    private String legalPersonPhone;

    /** 主要负责人 */
    @Excel(name = "主要负责人")
    private String keyPerson;

    /** 主要负责人手机 */
    @Excel(name = "主要负责人手机")
    private String keyPersonPhone;

    /** 安全负责人 */
    @Excel(name = "安全负责人")
    private String safetyPerson;

    /** 安全负责人手机 */
    @Excel(name = "安全负责人手机")
    private String safetyPersonPhone;

    /** 创建人id */
    @Excel(name = "创建人id")
    private String createUserId;

    /** 更新人id */
    @Excel(name = "更新人id")
    private String updateUserId;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setUnitName(String unitName) 
    {
        this.unitName = unitName;
    }

    public String getUnitName() 
    {
        return unitName;
    }
    public void setOrgCode(String orgCode) 
    {
        this.orgCode = orgCode;
    }

    public String getOrgCode() 
    {
        return orgCode;
    }
    public void setRunAddress(String runAddress) 
    {
        this.runAddress = runAddress;
    }

    public String getRunAddress() 
    {
        return runAddress;
    }
    public void setRegAddress(String regAddress) 
    {
        this.regAddress = regAddress;
    }

    public String getRegAddress() 
    {
        return regAddress;
    }
    public void setRegulationType(String regulationType) 
    {
        this.regulationType = regulationType;
    }

    public String getRegulationType() 
    {
        return regulationType;
    }
    public void setRegDate(Date regDate) 
    {
        this.regDate = regDate;
    }

    public Date getRegDate() 
    {
        return regDate;
    }
    public void setBusinessTerm(String businessTerm) 
    {
        this.businessTerm = businessTerm;
    }

    public String getBusinessTerm() 
    {
        return businessTerm;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setBusinessScope(String businessScope) 
    {
        this.businessScope = businessScope;
    }

    public String getBusinessScope() 
    {
        return businessScope;
    }
    public void setEmployeeNum(String employeeNum) 
    {
        this.employeeNum = employeeNum;
    }

    public String getEmployeeNum() 
    {
        return employeeNum;
    }
    public void setLegalPerson(String legalPerson) 
    {
        this.legalPerson = legalPerson;
    }

    public String getLegalPerson() 
    {
        return legalPerson;
    }
    public void setLegalPersonPhone(String legalPersonPhone) 
    {
        this.legalPersonPhone = legalPersonPhone;
    }

    public String getLegalPersonPhone() 
    {
        return legalPersonPhone;
    }
    public void setKeyPerson(String keyPerson) 
    {
        this.keyPerson = keyPerson;
    }

    public String getKeyPerson() 
    {
        return keyPerson;
    }
    public void setKeyPersonPhone(String keyPersonPhone) 
    {
        this.keyPersonPhone = keyPersonPhone;
    }

    public String getKeyPersonPhone() 
    {
        return keyPersonPhone;
    }
    public void setSafetyPerson(String safetyPerson) 
    {
        this.safetyPerson = safetyPerson;
    }

    public String getSafetyPerson() 
    {
        return safetyPerson;
    }
    public void setSafetyPersonPhone(String safetyPersonPhone) 
    {
        this.safetyPersonPhone = safetyPersonPhone;
    }

    public String getSafetyPersonPhone() 
    {
        return safetyPersonPhone;
    }
    public void setCreateUserId(String createUserId) 
    {
        this.createUserId = createUserId;
    }

    public String getCreateUserId() 
    {
        return createUserId;
    }
    public void setUpdateUserId(String updateUserId) 
    {
        this.updateUserId = updateUserId;
    }

    public String getUpdateUserId() 
    {
        return updateUserId;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    public String getDutyPhone() {
        return dutyPhone;
    }

    public void setDutyPhone(String dutyPhone) {
        this.dutyPhone = dutyPhone;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("unitName", getUnitName())
            .append("orgCode", getOrgCode())
            .append("runAddress", getRunAddress())
            .append("regAddress", getRegAddress())
            .append("regulationType", getRegulationType())
            .append("regDate", getRegDate())
            .append("businessTerm", getBusinessTerm())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("businessScope", getBusinessScope())
            .append("employeeNum", getEmployeeNum())
            .append("legalPerson", getLegalPerson())
            .append("legalPersonPhone", getLegalPersonPhone())
            .append("keyPerson", getKeyPerson())
            .append("keyPersonPhone", getKeyPersonPhone())
            .append("safetyPerson", getSafetyPerson())
            .append("safetyPersonPhone", getSafetyPersonPhone())
            .append("createUserId", getCreateUserId())
            .append("updateUserId", getUpdateUserId())
            .append("updateTime", getUpdateTime())
            .append("createTime", getCreateTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
