package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 设备信息管理对象 t_device_info
 * 
 * @author zehong
 * @date 2022-07-02
 */
public class TDeviceInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String deviceName;

    /** 设备编码 */
    @Excel(name = "设备编码")
    private String deviceCode;

    /** 设备状态（0正常 1报警 2离线） */
    private String deviceStatus;

    /** 设备类型 */
    @Excel(name = "设备类型(液位探测器/气体报警器/压力报警器)", readConverterExp = "1=液位探测器,2=气体报警器,3=压力报警器")
    private String deviceType;

    /** 位号 */
    @Excel(name = "位号")
    private String tagNumber;

    /** 设备等级 */
    @Excel(name = "设备等级(一级危险源/二级危险源/三级危险源)", readConverterExp = "1=一级危险源,2=二级危险源,3=三级危险源")
    private String deviceGrade;

    /** 安装位置 */
    @Excel(name = "安装位置")
    private String installLocation;

    /** 是否特种设备（0否，1是） */
    @Excel(name = "是否特种设备(是/否)", readConverterExp = "0=否,1=是")
    private String isSpecial;

    /** 负责人 */
    @Excel(name = "负责人")
    private String responsiblePerson;

    /** 负责人电话 */
    @Excel(name = "负责人电话")
    private String responsiblePhone;

    /** 备注信息 */
    @Excel(name = "备注信息")
    private String remarks;

    /** 是否作废(0正常，1作废) */
    @Excel(name = "是否作废(0正常，1作废)")
    private String isCancel;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setDeviceName(String deviceName) 
    {
        this.deviceName = deviceName;
    }

    public String getDeviceName() 
    {
        return deviceName;
    }
    public void setDeviceCode(String deviceCode) 
    {
        this.deviceCode = deviceCode;
    }

    public String getDeviceCode() 
    {
        return deviceCode;
    }
    public void setDeviceStatus(String deviceStatus) 
    {
        this.deviceStatus = deviceStatus;
    }

    public String getDeviceStatus() 
    {
        return deviceStatus;
    }
    public void setDeviceType(String deviceType) 
    {
        this.deviceType = deviceType;
    }

    public String getDeviceType() 
    {
        return deviceType;
    }
    public void setTagNumber(String tagNumber) 
    {
        this.tagNumber = tagNumber;
    }

    public String getTagNumber() 
    {
        return tagNumber;
    }
    public void setDeviceGrade(String deviceGrade) 
    {
        this.deviceGrade = deviceGrade;
    }

    public String getDeviceGrade() 
    {
        return deviceGrade;
    }
    public void setInstallLocation(String installLocation) 
    {
        this.installLocation = installLocation;
    }

    public String getInstallLocation() 
    {
        return installLocation;
    }
    public void setIsSpecial(String isSpecial) 
    {
        this.isSpecial = isSpecial;
    }

    public String getIsSpecial() 
    {
        return isSpecial;
    }
    public void setResponsiblePerson(String responsiblePerson) 
    {
        this.responsiblePerson = responsiblePerson;
    }

    public String getResponsiblePerson() 
    {
        return responsiblePerson;
    }
    public void setResponsiblePhone(String responsiblePhone) 
    {
        this.responsiblePhone = responsiblePhone;
    }

    public String getResponsiblePhone() 
    {
        return responsiblePhone;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getIsCancel() {
        return isCancel;
    }

    public void setIsCancel(String isCancel) {
        this.isCancel = isCancel;
    }
}
