package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 承包商及访客培训考试结果详情对象 t_contractor_train_result_detail
 * 
 * @author wu
 * @date 2022-12-30
 */
public class TContractorTrainResultDetail extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 结果详情id */
    private Long detailId;

    /** 结果关联id */
    @Excel(name = "结果关联id")
    private Long resultId;

    /** 题目内容 */
    @Excel(name = "题目内容")
    private String topicTitle;

    /** 题目选项（json） */
    @Excel(name = "题目选项", readConverterExp = "j=son")
    private String topicOption;

    /** 答案 */
    @Excel(name = "答案")
    private Integer answer;

    /** 所选答案 */
    @Excel(name = "所选答案")
    private Integer answerChoice;

    /** 答题结果：0 对，1 错 */
    @Excel(name = "答题结果：0 对，1 错")
    private String result;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    public void setDetailId(Long detailId) 
    {
        this.detailId = detailId;
    }

    public Long getDetailId() 
    {
        return detailId;
    }
    public void setResultId(Long resultId) 
    {
        this.resultId = resultId;
    }

    public Long getResultId() 
    {
        return resultId;
    }
    public void setTopicTitle(String topicTitle) 
    {
        this.topicTitle = topicTitle;
    }

    public String getTopicTitle() 
    {
        return topicTitle;
    }
    public void setTopicOption(String topicOption) 
    {
        this.topicOption = topicOption;
    }

    public String getTopicOption() 
    {
        return topicOption;
    }
    public void setAnswer(Integer answer) 
    {
        this.answer = answer;
    }

    public Integer getAnswer() 
    {
        return answer;
    }
    public void setAnswerChoice(Integer answerChoice) 
    {
        this.answerChoice = answerChoice;
    }

    public Integer getAnswerChoice() 
    {
        return answerChoice;
    }
    public void setResult(String result) 
    {
        this.result = result;
    }

    public String getResult() 
    {
        return result;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("detailId", getDetailId())
            .append("resultId", getResultId())
            .append("topicTitle", getTopicTitle())
            .append("topicOption", getTopicOption())
            .append("answer", getAnswer())
            .append("answerChoice", getAnswerChoice())
            .append("result", getResult())
            .append("createTime", getCreateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
