package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 承包商及访客培训考试结果详情对象 t_contractor_train_result
 *
 * @author zehong
 * @date 2022-12-27
 */
public class TContractorTrainResult extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 结果id */
    private Long resultId;

    /** 所属单位 */
    @Excel(name = "所属单位")
    private String beyondUnit;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 性别：0 男，1 女 */
    @Excel(name = "性别：0 男，1 女")
    private String sex;

    /** 手机号 */
    @Excel(name = "手机号")
    private String phoneNum;

    /** 考试开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "考试开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date testBeginTime;

    /** 考试结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "考试结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date testEndTime;

    /** 答对数量 */
    @Excel(name = "答对数量")
    private String score;

    /** 是否合格：0 合格，1 不合格 */
    @Excel(name = "是否合格：0 合格，1 不合格")
    private String isQualified;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    private String answers;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getAnswers() {
        return answers;
    }

    public void setAnswers(String answers) {
        this.answers = answers;
    }

    public void setResultId(Long resultId)
    {
        this.resultId = resultId;
    }

    public Long getResultId()
    {
        return resultId;
    }
    public void setBeyondUnit(String beyondUnit)
    {
        this.beyondUnit = beyondUnit;
    }

    public String getBeyondUnit()
    {
        return beyondUnit;
    }
    public void setName(String name)
    {
        this.name = name;
    }

    public String getName()
    {
        return name;
    }
    public void setSex(String sex)
    {
        this.sex = sex;
    }

    public String getSex()
    {
        return sex;
    }
    public void setPhoneNum(String phoneNum)
    {
        this.phoneNum = phoneNum;
    }

    public String getPhoneNum()
    {
        return phoneNum;
    }
    public void setTestBeginTime(Date testBeginTime)
    {
        this.testBeginTime = testBeginTime;
    }

    public Date getTestBeginTime()
    {
        return testBeginTime;
    }
    public void setTestEndTime(Date testEndTime)
    {
        this.testEndTime = testEndTime;
    }

    public Date getTestEndTime()
    {
        return testEndTime;
    }
    public void setScore(String score)
    {
        this.score = score;
    }

    public String getScore()
    {
        return score;
    }
    public void setIsQualified(String isQualified)
    {
        this.isQualified = isQualified;
    }

    public String getIsQualified()
    {
        return isQualified;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    @Override
    public String toString() {
        return "TContractorTrainResult{" +
                "resultId=" + resultId +
                ", beyondUnit='" + beyondUnit + '\'' +
                ", name='" + name + '\'' +
                ", sex='" + sex + '\'' +
                ", phoneNum='" + phoneNum + '\'' +
                ", testBeginTime=" + testBeginTime +
                ", testEndTime=" + testEndTime +
                ", score='" + score + '\'' +
                ", isQualified='" + isQualified + '\'' +
                ", isDel='" + isDel + '\'' +
                ", answers='" + answers + '\'' +
                '}';
    }
}
