package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 承包商及访客培训题库对象 t_contractor_train_course_topic
 * 
 * @author zehong
 * @date 2022-12-27
 */
public class TContractorTrainCourseTopic extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 题目id */
    private Long topicId;

    /** 所属培训id */
    @Excel(name = "所属培训id")
    private Long contractorCourseId;

    /** 题目内容 */
    @Excel(name = "题目内容")
    private String topicTitle;

    /** 题目选项（json） */
    @Excel(name = "题目选项", readConverterExp = "j=son")
    private String topicOption;

    /** 答案 */
    @Excel(name = "答案")
    private Integer answer;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    public void setTopicId(Long topicId) 
    {
        this.topicId = topicId;
    }

    public Long getTopicId() 
    {
        return topicId;
    }
    public void setContractorCourseId(Long contractorCourseId) 
    {
        this.contractorCourseId = contractorCourseId;
    }

    public Long getContractorCourseId() 
    {
        return contractorCourseId;
    }
    public void setTopicTitle(String topicTitle) 
    {
        this.topicTitle = topicTitle;
    }

    public String getTopicTitle() 
    {
        return topicTitle;
    }
    public void setTopicOption(String topicOption) 
    {
        this.topicOption = topicOption;
    }

    public String getTopicOption() 
    {
        return topicOption;
    }
    public void setAnswer(Integer answer) 
    {
        this.answer = answer;
    }

    public Integer getAnswer() 
    {
        return answer;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("topicId", getTopicId())
            .append("contractorCourseId", getContractorCourseId())
            .append("topicTitle", getTopicTitle())
            .append("topicOption", getTopicOption())
            .append("answer", getAnswer())
            .append("createTime", getCreateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
