package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 承包商及访客培训对象 t_contractor_train_course
 * 
 * @author zehong
 * @date 2022-12-27
 */
public class TContractorTrainCourse extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 培训id */
    private Long contractorCourseId;

    /** 培训名称 */
    @Excel(name = "培训名称")
    private String courseName;

    /** 培训内容 */
    @Excel(name = "培训内容")
    private String courseConent;

    /** 培训附件 */
    @Excel(name = "培训附件")
    private String enclosure;

    /** 培训视频 */
    @Excel(name = "培训视频")
    private String video;

    /** 答题合格数 */
    @Excel(name = "答题合格数")
    private Integer qualifiedNum;

    /** 录入题数量 */
    @Excel(name = "录入题数量")
    private Integer topicNum;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createUser;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    public void setContractorCourseId(Long contractorCourseId) 
    {
        this.contractorCourseId = contractorCourseId;
    }

    public Long getContractorCourseId() 
    {
        return contractorCourseId;
    }
    public void setCourseName(String courseName) 
    {
        this.courseName = courseName;
    }

    public String getCourseName() 
    {
        return courseName;
    }
    public void setCourseConent(String courseConent) 
    {
        this.courseConent = courseConent;
    }

    public String getCourseConent() 
    {
        return courseConent;
    }
    public void setEnclosure(String enclosure) 
    {
        this.enclosure = enclosure;
    }

    public String getEnclosure() 
    {
        return enclosure;
    }
    public void setVideo(String video) 
    {
        this.video = video;
    }

    public String getVideo() 
    {
        return video;
    }
    public void setQualifiedNum(Integer qualifiedNum) 
    {
        this.qualifiedNum = qualifiedNum;
    }

    public Integer getQualifiedNum() 
    {
        return qualifiedNum;
    }
    public void setTopicNum(Integer topicNum) 
    {
        this.topicNum = topicNum;
    }

    public Integer getTopicNum() 
    {
        return topicNum;
    }
    public void setCreateUser(String createUser) 
    {
        this.createUser = createUser;
    }

    public String getCreateUser() 
    {
        return createUser;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("contractorCourseId", getContractorCourseId())
            .append("courseName", getCourseName())
            .append("courseConent", getCourseConent())
            .append("enclosure", getEnclosure())
            .append("video", getVideo())
            .append("qualifiedNum", getQualifiedNum())
            .append("topicNum", getTopicNum())
            .append("createTime", getCreateTime())
            .append("createUser", getCreateUser())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
