package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 承包商人员信息对象 t_contractor_person
 * 
 * @author zehong
 * @date 2022-06-29
 */
public class TContractorPerson extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    private Long contractorId;

    /** 人员姓名 */
    @Excel(name = "人员姓名")
    private String name;

    /** 年龄 */
    @Excel(name = "年龄")
    private Long age;

    /** 性别 */
    @Excel(name = "性别")
    private String sex;

    /** 手机号 */
    @Excel(name = "手机号")
    private String phone;

    /** 资质证书名称 */
    @Excel(name = "资质证书名称")
    private String certificateName;

    /** 资质证书地址 */
    @Excel(name = "资质证书地址")
    private String certificateUrl;

    /** 承包商状态（是否标记黑名单） */
    @Excel(name = "承包商状态", readConverterExp = "是=否标记黑名单")
    private String status;

    /** 删除标志（0正常，1删除） */
    @Excel(name = "删除标志", readConverterExp = "0=正常，1删除")
    private String isDel;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public Long getContractorId() {
        return contractorId;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setAge(Long age) 
    {
        this.age = age;
    }

    public Long getAge() 
    {
        return age;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public void setPhone(String phone)
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setCertificateName(String certificateName) 
    {
        this.certificateName = certificateName;
    }

    public String getCertificateName() 
    {
        return certificateName;
    }
    public void setCertificateUrl(String certificateUrl) 
    {
        this.certificateUrl = certificateUrl;
    }

    public String getCertificateUrl() 
    {
        return certificateUrl;
    }
    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("name", getName())
            .append("age", getAge())
            .append("sex", getSex())
            .append("phone", getPhone())
            .append("certificateName", getCertificateName())
            .append("certificateUrl", getCertificateUrl())
            .append("status", getStatus())
            .append("isDel", getIsDel())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
