package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 承包商信息对象 t_contractor
 * 
 * @author zehong
 * @date 2022-06-29
 */
public class TContractor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 承包商单位名称 */
    @Excel(name = "承包商单位名称")
    private String contractorName;

    /** 团队资质证照名称 */
    @Excel(name = "团队资质证照名称")
    private String certificateName;

    /** 团队资质证照地址 */
    @Excel(name = "团队资质证照地址")
    private String certificateUrl;

    /** 团队信息记录 */
    @Excel(name = "团队信息记录")
    private String teamInformation;

    /** 承包商评定 */
    @Excel(name = "承包商评定")
    private String contractorEvaluate;

    /** 违章记录 */
    @Excel(name = "违章记录")
    private String violationRecords;

    /** 法定代表人 */
    @Excel(name = "法定代表人")
    private String legalPerson;

    /** 法定代表人手机 */
    @Excel(name = "法定代表人手机")
    private String legalPersonPhone;

    /** 主要负责人 */
    @Excel(name = "主要负责人")
    private String keyPerson;

    /** 主要负责人手机 */
    @Excel(name = "主要负责人手机")
    private String keyPersonPhone;

    /** 安全负责人 */
    @Excel(name = "安全负责人")
    private String safetyPerson;

    /** 安全负责人手机 */
    @Excel(name = "安全负责人手机")
    private String safetyPersonPhone;

    /** 承包商状态（是否标记黑名单） */
    @Excel(name = "承包商状态", readConverterExp = "是=否标记黑名单")
    private String status;

    /** 删除标志（0正常，1删除） */
    @Excel(name = "删除标志", readConverterExp = "0=正常，1删除")
    private String isDel;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setContractorName(String contractorName) 
    {
        this.contractorName = contractorName;
    }

    public String getContractorName() 
    {
        return contractorName;
    }
    public void setCertificateName(String certificateName) 
    {
        this.certificateName = certificateName;
    }

    public String getCertificateName() 
    {
        return certificateName;
    }
    public void setCertificateUrl(String certificateUrl) 
    {
        this.certificateUrl = certificateUrl;
    }

    public String getCertificateUrl() 
    {
        return certificateUrl;
    }
    public void setTeamInformation(String teamInformation) 
    {
        this.teamInformation = teamInformation;
    }

    public String getTeamInformation() 
    {
        return teamInformation;
    }
    public void setContractorEvaluate(String contractorEvaluate) 
    {
        this.contractorEvaluate = contractorEvaluate;
    }

    public String getContractorEvaluate() 
    {
        return contractorEvaluate;
    }
    public void setViolationRecords(String violationRecords) 
    {
        this.violationRecords = violationRecords;
    }

    public String getViolationRecords() 
    {
        return violationRecords;
    }
    public void setLegalPerson(String legalPerson) 
    {
        this.legalPerson = legalPerson;
    }

    public String getLegalPerson() 
    {
        return legalPerson;
    }
    public void setLegalPersonPhone(String legalPersonPhone) 
    {
        this.legalPersonPhone = legalPersonPhone;
    }

    public String getLegalPersonPhone() 
    {
        return legalPersonPhone;
    }
    public void setKeyPerson(String keyPerson) 
    {
        this.keyPerson = keyPerson;
    }

    public String getKeyPerson() 
    {
        return keyPerson;
    }
    public void setKeyPersonPhone(String keyPersonPhone) 
    {
        this.keyPersonPhone = keyPersonPhone;
    }

    public String getKeyPersonPhone() 
    {
        return keyPersonPhone;
    }
    public void setSafetyPerson(String safetyPerson) 
    {
        this.safetyPerson = safetyPerson;
    }

    public String getSafetyPerson() 
    {
        return safetyPerson;
    }
    public void setSafetyPersonPhone(String safetyPersonPhone) 
    {
        this.safetyPersonPhone = safetyPersonPhone;
    }

    public String getSafetyPersonPhone() 
    {
        return safetyPersonPhone;
    }
    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("contractorName", getContractorName())
            .append("certificateName", getCertificateName())
            .append("certificateUrl", getCertificateUrl())
            .append("teamInformation", getTeamInformation())
            .append("contractorEvaluate", getContractorEvaluate())
            .append("violationRecords", getViolationRecords())
            .append("legalPerson", getLegalPerson())
            .append("legalPersonPhone", getLegalPersonPhone())
            .append("keyPerson", getKeyPerson())
            .append("keyPersonPhone", getKeyPersonPhone())
            .append("safetyPerson", getSafetyPerson())
            .append("safetyPersonPhone", getSafetyPersonPhone())
            .append("status", getStatus())
            .append("isDel", getIsDel())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
