package com.zehong.system.domain;

import java.util.Date;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 题库题目对象 t_bank_subject
 *
 * @author zehong
 * @date 2022-12-15
 */
public class TBankSubject extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 题目id */
    private Long subjectId;

    /** 所属题库id */
    @Excel(name = "所属题库id")
    private Long bankId;

    /** 题目内容 */
    @ExcelProperty(value = "题干(必填)")
    private String topicTitle;

    /** 题目选项（json） */
    @Excel(name = "题目选项", readConverterExp = "j=son")
    private String topicOption;

    /** 答案 */
    @Excel(name = "正确答案（必填）")
    private int answer;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date datetime;

    public void setSubjectId(Long subjectId)
    {
        this.subjectId = subjectId;
    }

    public Long getSubjectId()
    {
        return subjectId;
    }
    public void setBankId(Long bankId)
    {
        this.bankId = bankId;
    }

    public Long getBankId()
    {
        return bankId;
    }
    public void setTopicTitle(String topicTitle)
    {
        this.topicTitle = topicTitle;
    }

    public String getTopicTitle()
    {
        return topicTitle;
    }
    public void setTopicOption(String topicOption)
    {
        this.topicOption = topicOption;
    }

    public String getTopicOption()
    {
        return topicOption;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public int getAnswer() {
        return answer;
    }

    public void setAnswer(int answer) {
        this.answer = answer;
    }

    public void setDatetime(Date datetime)
    {
        this.datetime = datetime;
    }

    public Date getDatetime()
    {
        return datetime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("subjectId", getSubjectId())
            .append("bankId", getBankId())
            .append("topicTitle", getTopicTitle())
            .append("topicOption", getTopicOption())
            .append("answer", getAnswer())
            .append("datetime", getDatetime())
            .toString();
    }
}
