package com.zehong.web.controller.workPermit;

import com.github.pagehelper.util.StringUtil;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TSpecialWorkPermit;
import com.zehong.system.domain.TSpecialWorkPermitSign;
import com.zehong.system.domain.TWorkPermit;
import com.zehong.system.service.ITSpecialWorkPermitService;
import com.zehong.system.service.ITSpecialWorkPermitSignService;
import com.zehong.system.service.ITWorkPermitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.ArrayList;
import java.util.List;

/**
 * 作业许可证Controller
 * 
 * @author zehong
 * @date 2022-08-18
 */
@RestController
@RequestMapping("/work/permit")
public class TWorkPermitController extends BaseController
{
    @Autowired
    private ITWorkPermitService tWorkPermitService;

    @Autowired
    private ITSpecialWorkPermitService tSpecialWorkPermitService;

    @Autowired
    private ITSpecialWorkPermitSignService tSpecialWorkPermitSignService;

    /**
     * 查询作业许可证列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TWorkPermit tWorkPermit)
    {
        startPage();
        List<TWorkPermit> list = tWorkPermitService.selectTWorkPermitList(tWorkPermit);
        //setOperator(list);
        setApprovalInfo(list);
        return getDataTable(list);
    }

    /**
     * 根据登录用户查询作业单
     * @param tWorkPermit
     * @return
     */
    @GetMapping("/selectTWorkPermitListByLoginUser")
    public TableDataInfo selectTWorkPermitListByLoginUser(TWorkPermit tWorkPermit){
        startPage();
        tWorkPermit.setCurrentLoginUser(SecurityUtils.getLoginUser().getUser().getUserId());
        List<TWorkPermit> list = tWorkPermitService.selectTWorkPermitListByLoginUser(tWorkPermit);
        //setOperator(list);
        setApprovalInfo(list);
        return getDataTable(list);
    }

    /**
     * 获取审核人信息
     * @param list 作业许可证列表
     */
    private void setApprovalInfo(List<TWorkPermit> list){
        for(TWorkPermit tWorkPermit : list){
            List<Long> approvalIds = new ArrayList<>();
            if("1".equals(tWorkPermit.getApplyStatus())){
                TSpecialWorkPermit tSpecialWorkPermit = new TSpecialWorkPermit();
                tSpecialWorkPermit.setWorkPermitId(tWorkPermit.getWorkPermitId());
                List<TSpecialWorkPermit> specialWorkPermits =tSpecialWorkPermitService.selectTSpecialWorkPermitList(tSpecialWorkPermit);
                for(TSpecialWorkPermit specialWorkPermit : specialWorkPermits){
                    TSpecialWorkPermitSign tSpecialWorkPermitSign = new TSpecialWorkPermitSign();
                    tSpecialWorkPermitSign.setPermitId(specialWorkPermit.getSpecialWorkPermitId());
                    List<TSpecialWorkPermitSign> specialWorkPermitSigns = tSpecialWorkPermitSignService.selectTSpecialWorkPermitSignList(tSpecialWorkPermitSign);
                    for(TSpecialWorkPermitSign specialWorkPermitSign: specialWorkPermitSigns){
                        approvalIds.add(specialWorkPermitSign.getStaffId());
                    }
                }
            }
            tWorkPermit.setApprovals(approvalIds);
        }

    }

    /**
     * 根据许可证状态及登录人设置操作权限
     * @param list 作业许可证列表
     */
    private void setOperator(List<TWorkPermit> list){
        //用户登录信息
        LoginUser user = SecurityUtils.getLoginUser();
        for(TWorkPermit workPermit : list){
            //申请单状态：0申请中，1安全分析中，2作业许可证申请
            // 3作业证审核，4作业前检查，5作业中，6关闭作业单 7风险评价 8 已完成
            switch (workPermit.getApplyStatus()){
                case "0":
                    //安全分析
                    if (workPermit.getLinkMan().equals(String.valueOf(user.getUser().getUserId()))
                            ||workPermit.getContractor().equals(user.getUser().getUserId())
                            ||workPermit.getRatifier().equals(user.getUser().getUserId())){
                        workPermit.setOperator(WorkPermitEnum.SAFEANALYSE.getValue());
                    }
                    break;
                case "1":
                    //审批中
                    if (workPermit.getRatifier().equals(user.getUser().getUserId())){
                        workPermit.setOperator(WorkPermitEnum.APPROVAL.getValue());
                    }
                    break;
                case "2":
                    //申请许可证
                    if (workPermit.getLinkMan().equals(String.valueOf(user.getUser().getUserId()))){
                        workPermit.setOperator(WorkPermitEnum.WORKPERMIT.getValue());
                    }
                    break;
                case "3":
                    //许可证审核
                    if (workPermit.getLinkMan().equals(String.valueOf(user.getUser().getUserId()))
                            ||workPermit.getContractor().equals(user.getUser().getUserId())
                            ||workPermit.getRatifier().equals(user.getUser().getUserId())){
                        workPermit.setOperator(WorkPermitEnum.REVIEW.getValue());
                    }
                    break;
                case "4":
                    //作业前检查
                    if(StringUtil.isNotEmpty(user.getUser().getRemark()) && user.getUser().getRemark().contains("-")){
                        if (String.valueOf(workPermit.getContractor()).equals(user.getUser().getRemark().split("-")[1])){
                            workPermit.setOperator(WorkPermitEnum.CHECK.getValue());
                        }
                    }

                    break;
                case "5":
                    //作业中
                    if (workPermit.getRatifier().longValue() == user.getUser().getUserId().longValue()
                            ||(StringUtil.isNotEmpty(user.getUser().getRemark()) && user.getUser().getRemark().contains("-")&& String.valueOf(workPermit.getContractor()).equals(user.getUser().getRemark().split("-")[1]))){
                        workPermit.setOperator(WorkPermitEnum.WORKING.getValue());
                    }
                    break;
                case "6":
                    //关闭作业单
                    if (workPermit.getRatifier().longValue() == user.getUser().getUserId().longValue()
                            || workPermit.getLinkMan().equals(String.valueOf(user.getUser().getUserId()))){
                        workPermit.setOperator(WorkPermitEnum.CLOSE.getValue());
                    }
                    break;
                default:
            }
        }
    }

    /**
     * 导出作业许可证列表
     */
    @Log(title = "作业许可证", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TWorkPermit tWorkPermit)
    {
        List<TWorkPermit> list = tWorkPermitService.selectTWorkPermitList(tWorkPermit);
        ExcelUtil<TWorkPermit> util = new ExcelUtil<TWorkPermit>(TWorkPermit.class);
        return util.exportExcel(list, "作业许可证数据");
    }

    /**
     * 获取作业许可证详细信息
     */
    @GetMapping(value = "/{workPermitId}")
    public AjaxResult getInfo(@PathVariable("workPermitId") Long workPermitId)
    {
        TWorkPermit workPermit = tWorkPermitService.selectTWorkPermitById(workPermitId);
        LoginUser user = SecurityUtils.getLoginUser();
        if(Integer.parseInt(workPermit.getApplyStatus()) >4){
            List<String> person = new ArrayList<>();
            if (StringUtil.isNotEmpty(user.getUser().getRemark()) && user.getUser().getRemark().contains("-")&& String.valueOf(workPermit.getContractor()).equals(user.getUser().getRemark().split("-")[1])){
                person.add("contractor");
            }
            if (workPermit.getRatifier().longValue() == user.getUser().getUserId().longValue() ){
                person.add("ratifier");
            }
            if(workPermit.getLinkMan().equals(String.valueOf(user.getUser().getUserId()))){
                person.add("apply");
            }
            workPermit.setSignPerson(person);
        }
        return AjaxResult.success(workPermit);
    }

    /**
     * app判断修改
     * @param workPermitId
     * @return
     */
    @GetMapping(value = "/selectUpdate")
    public AjaxResult selectUpdate(Long workPermitId)
    {
        return toAjax(tWorkPermitService.selectUpdate(workPermitId));
    }
    /**
     * 新增作业许可证
     */
    @Log(title = "作业许可证", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TWorkPermit tWorkPermit)
    {
        return toAjax(tWorkPermitService.insertTWorkPermit(tWorkPermit));
    }

    /**
     * 修改作业许可证
     */
    @Log(title = "作业许可证", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TWorkPermit tWorkPermit)
    {
        return toAjax(tWorkPermitService.updateTWorkPermit(tWorkPermit));
    }

    @GetMapping("/judgeSignUpdateTWorkPermit")
    public AjaxResult judgeSignUpdateTWorkPermit(TWorkPermit tWorkPermit){
        return AjaxResult.success(tWorkPermitService.judgeSignUpdateTWorkPermit(tWorkPermit));
    }

    /**
     * 删除作业许可证
     */
    @Log(title = "作业许可证", businessType = BusinessType.DELETE)
	@DeleteMapping("/{workPermitIds}")
    public AjaxResult remove(@PathVariable Long[] workPermitIds)
    {
        return toAjax(tWorkPermitService.deleteTWorkPermitByIds(workPermitIds));
    }


}
