package com.zehong.web.controller.workPermit;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSpecialWorkPermitSign;
import com.zehong.system.service.ITSpecialWorkPermitSignService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 【请填写功能名称】Controller
 * 
 * @author zehong
 * @date 2022-10-17
 */
@RestController
@RequestMapping("/workPermit/sign")
public class TSpecialWorkPermitSignController extends BaseController
{
    @Autowired
    private ITSpecialWorkPermitSignService tSpecialWorkPermitSignService;

    /**
     * 查询【请填写功能名称】列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sign:list')")
    @GetMapping("/list")
    public TableDataInfo list(TSpecialWorkPermitSign tSpecialWorkPermitSign)
    {
        startPage();
        List<TSpecialWorkPermitSign> list = tSpecialWorkPermitSignService.selectTSpecialWorkPermitSignList(tSpecialWorkPermitSign);
        return getDataTable(list);
    }

    /**
     * 导出【请填写功能名称】列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sign:export')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSpecialWorkPermitSign tSpecialWorkPermitSign)
    {
        List<TSpecialWorkPermitSign> list = tSpecialWorkPermitSignService.selectTSpecialWorkPermitSignList(tSpecialWorkPermitSign);
        ExcelUtil<TSpecialWorkPermitSign> util = new ExcelUtil<TSpecialWorkPermitSign>(TSpecialWorkPermitSign.class);
        return util.exportExcel(list, "【请填写功能名称】数据");
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sign:query')")
    @GetMapping(value = "/{signId}")
    public AjaxResult getInfo(@PathVariable("signId") Long signId)
    {
        return AjaxResult.success(tSpecialWorkPermitSignService.selectTSpecialWorkPermitSignById(signId));
    }

    /**
     * app添加
     */
    //@PreAuthorize("@ss.hasPermi('system:sign:add')")
    @Log(title = "批量添加", businessType = BusinessType.INSERT)
    @PostMapping(value = "/insertAll")
    public AjaxResult addAll(HttpServletRequest req, HttpServletResponse resp) throws Exception
    {
        StringBuffer sb = new StringBuffer() ;
        InputStream is = req.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is,"utf-8"));
        String s = "" ;
        while((s=br.readLine())!=null){
            sb.append(s) ;
        }
        if(sb.toString().length()<=0){
            return toAjax(0);
        }
        Map<String,Object> map  = (Map<String,Object>) JSON.parseObject(sb.toString());

        int a = 0;
        List<Map<String,Object>> list =(List<Map<String,Object>>) JSON.parse((String) map.get("signList"));
        for(Map<String,Object> m : list){
            TSpecialWorkPermitSign t = new TSpecialWorkPermitSign();
            t.setPermitId(((Integer) m.get("permitId")).longValue());
            t.setStaffId(((Integer) m.get("staffId")).longValue());
            t.setStaffType((String) m.get("staffType"));
           a = tSpecialWorkPermitSignService.insertTSpecialWorkPermitSign(t);
        }
        return toAjax(1);
    }
    /**
     * 新增【请填写功能名称】
     */
    //@PreAuthorize("@ss.hasPermi('system:sign:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSpecialWorkPermitSign tSpecialWorkPermitSign)
    {
        return toAjax(tSpecialWorkPermitSignService.insertTSpecialWorkPermitSign(tSpecialWorkPermitSign));
    }

    /**
     * 修改【请填写功能名称】
     */
    //@PreAuthorize("@ss.hasPermi('system:sign:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSpecialWorkPermitSign tSpecialWorkPermitSign)
    {
        return toAjax(tSpecialWorkPermitSignService.updateTSpecialWorkPermitSign(tSpecialWorkPermitSign));
    }

    /**
     * 删除【请填写功能名称】
     */
    //@PreAuthorize("@ss.hasPermi('system:sign:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{signIds}")
    public AjaxResult remove(@PathVariable Long[] signIds)
    {
        return toAjax(tSpecialWorkPermitSignService.deleteTSpecialWorkPermitSignByIds(signIds));
    }

    @PostMapping("/batchUpdateSignWorkPermit")
    public AjaxResult batchUpdateSignWorkPermit(@RequestBody List<TSpecialWorkPermitSign> tSpecialWorkPermitSigns){
        try {
            return toAjax(tSpecialWorkPermitSignService.batchUpdateSignWorkPermit(tSpecialWorkPermitSigns));
        }catch (Exception e){
            logger.error("批量更新签名失败！");
        }
        return AjaxResult.error();
    }
}
