package com.zehong.web.controller.workPermit;

import java.util.List;

import com.zehong.system.domain.vo.TWorkPermitVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSpecialWorkPermit;
import com.zehong.system.service.ITSpecialWorkPermitService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 特殊作业许可证Controller
 * 
 * @author zehong
 * @date 2022-08-25
 */
@RestController
@RequestMapping("/special/permit")
public class TSpecialWorkPermitController extends BaseController
{
    @Autowired
    private ITSpecialWorkPermitService tSpecialWorkPermitService;

    /**
     * 查询特殊作业许可证列表
     */
    //@PreAuthorize("@ss.hasPermi('special:permit:list')")
    @GetMapping("/list")
    public TableDataInfo list(TSpecialWorkPermit tSpecialWorkPermit)
    {
        startPage();
        List<TSpecialWorkPermit> list = tSpecialWorkPermitService.selectTSpecialWorkPermitList(tSpecialWorkPermit);
        return getDataTable(list);
    }

    /**
     * 导出特殊作业许可证列表
     */
    //@PreAuthorize("@ss.hasPermi('special:permit:export')")
    @Log(title = "特殊作业许可证", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSpecialWorkPermit tSpecialWorkPermit)
    {
        List<TSpecialWorkPermit> list = tSpecialWorkPermitService.selectTSpecialWorkPermitList(tSpecialWorkPermit);
        ExcelUtil<TSpecialWorkPermit> util = new ExcelUtil<TSpecialWorkPermit>(TSpecialWorkPermit.class);
        return util.exportExcel(list, "特殊作业许可证数据");
    }

    /**
     * 获取特殊作业许可证详细信息
     */
    //@PreAuthorize("@ss.hasPermi('special:permit:query')")
    @GetMapping(value = "/{specialWorkPermitId}")
    public AjaxResult getInfo(@PathVariable("specialWorkPermitId") Long specialWorkPermitId)
    {
        return AjaxResult.success(tSpecialWorkPermitService.selectTSpecialWorkPermitById(specialWorkPermitId));
    }

    /**
     * 新增特殊作业许可证
     */
    //@PreAuthorize("@ss.hasPermi('special:permit:add')")
    @Log(title = "特殊作业许可证", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSpecialWorkPermit tSpecialWorkPermit)
    {
        return tSpecialWorkPermitService.insertTSpecialWorkPermit(tSpecialWorkPermit) > 0 ? AjaxResult.success(tSpecialWorkPermit) : AjaxResult.error();
    }

    /**
     * 修改特殊作业许可证
     */
    //@PreAuthorize("@ss.hasPermi('special:permit:edit')")
    @Log(title = "特殊作业许可证", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSpecialWorkPermit tSpecialWorkPermit)
    {
        return toAjax(tSpecialWorkPermitService.updateTSpecialWorkPermit(tSpecialWorkPermit));
    }

    /**
     * 删除特殊作业许可证
     */
    //@PreAuthorize("@ss.hasPermi('special:permit:remove')")
    @Log(title = "特殊作业许可证", businessType = BusinessType.DELETE)
	@DeleteMapping("/{specialWorkPermitIds}")
    public AjaxResult remove(@PathVariable Long[] specialWorkPermitIds)
    {
        return toAjax(tSpecialWorkPermitService.deleteTSpecialWorkPermitByIds(specialWorkPermitIds));
    }

    /**
     * 批量新增特殊许可单
     * @param tWorkPermitVo 许可单实体
     * @return
     */
    @PostMapping("/addSpecialPermit")
    public AjaxResult addSpecialPermit(@RequestBody TWorkPermitVo tWorkPermitVo){
        return toAjax(tSpecialWorkPermitService.addSpecialPermit(tWorkPermitVo));
    }

    /**
     * 根据workPermitId查询作业单
     */
    @GetMapping("/getSpecialWorkPermitByWorkPermitId")
    public AjaxResult getSpecialWorkPermitByWorkPermitId(@RequestParam(value = "workPermitId") Long workPermitId){
        return AjaxResult.success(tSpecialWorkPermitService.getSpecialWorkPermitByWorkPermitId(workPermitId));
    }

    @PostMapping("/updateSpecialWorkStatus")
    public AjaxResult updateSpecialWorkStatus (@RequestBody TSpecialWorkPermit tSpecialWorkPermit){
        return AjaxResult.success(tSpecialWorkPermitService.updateSpecialWorkStatus(tSpecialWorkPermit));
    }
}
