package com.zehong.web.controller.videomonitor;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.util.StringUtil;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.redis.RedisCache;
import com.zehong.system.domain.TDeviceAlarmInfo;
import com.zehong.system.service.ITDeviceAlarmInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author geng
 * 订阅海康事件信息接收
 */
@RestController
@RequestMapping("/subscription")
public class SubscriptionEventController {

    private Logger logger = LoggerFactory.getLogger(SubscriptionEventController.class);

    @Autowired
    private RedisCache redisCache;
    @Autowired
    private ITDeviceAlarmInfoService tDeviceAlarmInfoService;

    /**
     * 烟雾检测订阅事件
     * @param smoke 入参
     * @return AjaxResult
     */
    @PostMapping("/smokeCheck")
    public AjaxResult smokeCheck(@RequestBody Map<String,Object> smoke){
        logger.info("烟雾检测信息："+ JSON.toJSONString(smoke));
        return AjaxResult.success();
    }

    /**
     * 烟火检测订阅事件
     * @param pyrotechnic 入参
     * @return AjaxResult
     */
    @PostMapping("/pyrotechnicCheck")
    public AjaxResult pyrotechnicCheck(@RequestBody Map<String,Object> pyrotechnic){
        logger.info("烟火检测信息："+ JSON.toJSONString(pyrotechnic));
        return AjaxResult.success();
    }

    @PostMapping("/faceVerification")
    public AjaxResult faceVerification(@RequestBody Map<String,Object> faceVeriy){
        logger.info("人脸验证信息："+ JSON.toJSONString(faceVeriy));
        return AjaxResult.success();
    }

    @PostMapping("/patrolCardCheck")
    public AjaxResult patrolCardCheck(@RequestBody Map<String,Object> patrolCard){
        logger.info("巡查卡比对信息信息："+ JSON.toJSONString(patrolCard));
        return AjaxResult.success();
    }

    /**
     * 设置订阅事件缓存
     * @param deviceCode 设备编号
     * @param imageUrl 报警图片信息
     * @return boolean
     */
    private boolean getEventCacheInfo(String deviceCode,String imageUrl){
        Map<String,TDeviceAlarmInfo> tDeviceAlarmInfoCache = redisCache.getCacheObject("dangroueSubsciription");
        if(ObjectUtil.isNotNull(tDeviceAlarmInfoCache) && tDeviceAlarmInfoCache.containsKey(deviceCode)){
            //更新设备预警图像信息
            if(StringUtil.isNotEmpty(imageUrl)){
                tDeviceAlarmInfoCache.get(deviceCode).setAlarmImageUrl(imageUrl);
            }
            tDeviceAlarmInfoCache.get(deviceCode).setAlarmBeginTime(new Date());
            redisCache.setCacheObject("dangrousSubsciription",tDeviceAlarmInfoCache);
            return true;
        }
        return false;
    }

    /**
     * 设置订阅事件缓存
     * @param deviceCode 设备编号
     * @param imageUrl 报警图片信息
     *
     * @return boolean
     */
    private boolean setEventCacheInfo(String deviceCode,String imageUrl) throws Exception {
        if(StringUtil.isEmpty(deviceCode)){
            throw new Exception("设备编号为空！");
        }
        Map<String,TDeviceAlarmInfo> tDeviceAlarmInfoCache = redisCache.getCacheObject("dangrousSubsciription");
        if(null !=tDeviceAlarmInfoCache && tDeviceAlarmInfoCache.containsKey(deviceCode)){
            //更新设备预警图像信息
            if(StringUtil.isNotEmpty(imageUrl)){
                tDeviceAlarmInfoCache.get(deviceCode).setAlarmImageUrl(imageUrl);
            }
            tDeviceAlarmInfoCache.get(deviceCode).setAlarmBeginTime(new Date());
            redisCache.setCacheObject("dangrousSubsciription",tDeviceAlarmInfoCache);
            return true;
        }
        return false;
    }

    /**
     * 初始化报警信息
     * @param deviceCode 设备编号
     * @param imageUrl 报警图片
     * @param type 报警类型
     * @return TDeviceAlarmInfo
     */
    private TDeviceAlarmInfo initAlarmInfo(String deviceCode,String imageUrl,int type){
        TDeviceAlarmInfo alarmInfo = new TDeviceAlarmInfo();
        alarmInfo.setRelationDeviceId(deviceCode);
        alarmInfo.setAlarmContent(type);
        alarmInfo.setAlarmBeginTime(new Date());
        alarmInfo.setAlarmStatus("0");
        if(StringUtil.isNotEmpty(imageUrl)){
            alarmInfo.setAlarmImageUrl(imageUrl);
        }
        tDeviceAlarmInfoService.insertTDeviceAlarmInfo(alarmInfo);
        Map<String,TDeviceAlarmInfo> tDeviceAlarmInfoCache = redisCache.getCacheObject("dangrousSubsciription");
        if(null != tDeviceAlarmInfoCache){
            tDeviceAlarmInfoCache.put(deviceCode,alarmInfo);
            redisCache.setCacheObject("dangrousSubsciription",tDeviceAlarmInfoCache);
        }else{
            Map<String,TDeviceAlarmInfo> alarmInfoMap = new HashMap<>(16);
            alarmInfoMap.put(deviceCode,alarmInfo);
            redisCache.setCacheObject("dangrousSubsciription",alarmInfoMap);
        }
        return alarmInfo;
    }

}
