package com.zehong.web.controller.train;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.zehong.system.domain.vo.PlanVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TTrainPlan;
import com.zehong.system.service.ITTrainPlanService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 培训计划Controller
 * 
 * @author zehong
 * @date 2022-09-17
 */
@Api("培训计划")
@RestController
@RequestMapping("/system/plan")
public class TTrainPlanController extends BaseController
{
    @Autowired
    private ITTrainPlanService tTrainPlanService;

    /**
     * 查询培训计划列表
     */
    @ApiOperation("培训计划列表")
    @GetMapping("/list")
    public AjaxResult list()
    {
        List<TTrainPlan> list = tTrainPlanService.selectTTrainPlanList(new TTrainPlan());
        return AjaxResult.success(list);
    }

    @ApiOperation("培训计划下拉列表")
    @GetMapping("/downList")
    public AjaxResult downList()
    {
        List<TTrainPlan> list = tTrainPlanService.selectTTrainPlanDownList();
        return AjaxResult.success(list);
    }
    /**
     * 导出培训计划列表
     */
    @Log(title = "培训计划", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTrainPlan tTrainPlan)
    {
        List<TTrainPlan> list = tTrainPlanService.selectTTrainPlanList(tTrainPlan);
        ExcelUtil<TTrainPlan> util = new ExcelUtil<TTrainPlan>(TTrainPlan.class);
        return util.exportExcel(list, "培训计划数据");
    }

    /**
     * 获取培训计划详细信息
     */
    @GetMapping(value = "/{planId}")
    public AjaxResult getInfo(@PathVariable("planId") Long planId)
    {
        return AjaxResult.success(tTrainPlanService.selectTTrainPlanById(planId));
    }

    /**
     * 新增培训计划
     */
    @ApiOperation("新增培训计划")
    @Log(title = "培训计划", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PlanVo planVo)
    {
        TTrainPlan tTrainPlan = new TTrainPlan();
        tTrainPlan.setPlanName(planVo.getPlanName());
        tTrainPlan.setPersonnelType(planVo.getPersonnelType());
        List<Map<String,Object>> list = (List<Map<String,Object>>) JSON.parse(planVo.getPeopleList());
        return AjaxResult.success(tTrainPlanService.insertTTrainPlan(tTrainPlan,list));
    }

    /**
     * 修改培训计划
     */
    @ApiOperation("编辑培训计划")
    @Log(title = "培训计划", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PlanVo planVo)
    {
        if(planVo.getPlanId()==null){
            return AjaxResult.error("计划id不可为空");
        }
        TTrainPlan tTrainPlan = new TTrainPlan();
        tTrainPlan.setPlanId(planVo.getPlanId());
        tTrainPlan.setPlanName(planVo.getPlanName());
        tTrainPlan.setPersonnelType(planVo.getPersonnelType());
        List<Map<String,Object>> list = (List<Map<String,Object>>) JSON.parse(planVo.getPeopleList());
        return toAjax(tTrainPlanService.updateTTrainPlan(tTrainPlan,list));
    }

    /**
     * 删除培训计划
     */
    @Log(title = "培训计划", businessType = BusinessType.DELETE)
	@DeleteMapping("/{planIds}")
    public AjaxResult remove(@PathVariable Long[] planIds)
    {
        return toAjax(tTrainPlanService.deleteTTrainPlanByIds(planIds));
    }

    /**
     * 删除培训计划
     * @param planId
     * @return
     */
    @ApiOperation("删除培训计划")
    @Log(title = "培训计划", businessType = BusinessType.DELETE)
    @DeleteMapping("/deleteOne")
    public AjaxResult deletePlan(Long planId)
    {
        return toAjax(tTrainPlanService.deleteTTrainPlanById(planId));
    }
}
